/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.sdk;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.request.AckRequest;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.request.SubRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import com.xforceplus.janus.message.sdk.response.SubResponse;
import com.xforceplus.janus.message.sdk.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBClient {
    static Logger log = LoggerFactory.getLogger(MBClient.class);
    private String url;
    private String token;

    private MBClient() {
    }

    public static MBClient getInstance(String url, String token) {
        MBClient mbClient = SingletonClassInstance.instance;
        if (Objects.isNull(mbClient.getUrl()) || "".equals(mbClient.getUrl())) {
            mbClient.setUrl(url);
            mbClient.setToken(token);
        }
        return mbClient;
    }

    public PubResponse pub(PubRequest request) {
        return PubResponse.transform(this.exec(request));
    }

    public SubResponse sub(SubRequest request) {
        return SubResponse.transform(this.exec(request));
    }

    public AckResponse ack(AckRequest request) {
        return AckResponse.transform(this.exec(request));
    }

    private HttpResp exec(AbsMbRequest request) {
        String url = this.getUrl() + request.getRequestPath();
        Map<String, String> headers = request.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("MB_TOKEN", this.getToken());
        headers.put("content-type", "application/json");
        headers.put("CLIENT_VERSION", "1.0.6.7");
        String requestId = request.requestId();
        headers.put("CLIENT_REQUEST_ID", requestId);
        log.debug("requestId[{}]\u8c03\u7528\u5f00\u59cbrequestPath[{}]", (Object)requestId, (Object)request.getRequestPath());
        HttpResp resp = null;
        if ("get".equals(request.httpMethod())) {
            resp = HttpUtils.getRequest(url, headers, request.getParam());
        } else if ("post".equals(request.httpMethod())) {
            resp = HttpUtils.postRequest(url, headers, request.getParamJson());
        } else if ("put".equals(request.httpMethod())) {
            resp = HttpUtils.putRequest(url, headers, request.getParamJson());
        }
        log.debug("requestId[{}]\u8c03\u7528\u7ed3\u675fresponse[{}]", (Object)requestId, (Object)JacksonUtil.getInstance().toJson((Object)resp));
        return resp;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    private static class SingletonClassInstance {
        private static final MBClient instance = new MBClient();

        private SingletonClassInstance() {
        }
    }
}

