/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.sdk.utils;

import com.xforceplus.janus.message.sdk.core.HttpResp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static String defaultEncoding = "utf-8";
    static Logger log = LoggerFactory.getLogger(HttpUtils.class);
    static CloseableHttpClient httpClient = null;

    public static HttpResp postRequest(String url, Map<String, String> headers, String json) {
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        HttpPost httpPost = new HttpPost(url);
        HttpUtils.buildHeaders((HttpRequestBase)httpPost, headers);
        if (json != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.forName(defaultEncoding)));
        }
        return HttpUtils.call(httpClient, (HttpRequestBase)httpPost);
    }

    public static HttpResp putRequest(String url, Map<String, String> headers, String json) {
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        HttpPut httpPut = new HttpPut(url);
        HttpUtils.buildHeaders((HttpRequestBase)httpPut, headers);
        if (json != null) {
            httpPut.setEntity((HttpEntity)new StringEntity(json, Charset.forName(defaultEncoding)));
        }
        return HttpUtils.call(httpClient, (HttpRequestBase)httpPut);
    }

    public static HttpResp getRequest(String url, Map<String, String> headers, Map<String, String> params) {
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        String apiUrl = url;
        if (null != params && params.size() > 0) {
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(params.get(key));
                ++i;
            }
            apiUrl = apiUrl + param;
        }
        HttpGet httpGet = new HttpGet(apiUrl);
        HttpUtils.buildHeaders((HttpRequestBase)httpGet, headers);
        return HttpUtils.call(httpClient, (HttpRequestBase)httpGet);
    }

    private static HttpResp call(CloseableHttpClient httpClient, HttpRequestBase requestBase) {
        HttpResp httpResp = new HttpResp();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)requestBase);
            httpResp.setHttpStatus(response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                response.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            try {
                String result = EntityUtils.toString((HttpEntity)entity, (String)defaultEncoding);
                httpResp.setRespStr(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return httpResp;
    }

    private static void buildHeaders(HttpRequestBase requestBase, Map<String, String> headers) {
        if (null != headers && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                requestBase.addHeader((Header)new BasicHeader(key, value));
            }
        }
    }

    public static CloseableHttpClient buildHttpClient() {
        if (httpClient == null) {
            try {
                RegistryBuilder builder = RegistryBuilder.create();
                PlainConnectionSocketFactory factory = new PlainConnectionSocketFactory();
                builder.register("http", (Object)factory);
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                SSLContext context = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                builder.register("https", (Object)sslFactory);
                Registry registry = builder.build();
                PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
                ConnectionConfig connConfig = ConnectionConfig.custom().setCharset(Charset.forName(defaultEncoding)).build();
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(5000).build();
                manager.setDefaultConnectionConfig(connConfig);
                manager.setDefaultSocketConfig(socketConfig);
                manager.setMaxTotal(100);
                httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler(HttpUtils.retryHandler()).build();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return httpClient;
    }

    private static HttpRequestRetryHandler retryHandler() {
        return (exception, executionCount, context) -> {
            boolean idempotent;
            log.info("try request: [{}]", (Object)executionCount);
            if (executionCount >= 5) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
    }
}

