/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.sdk.core;

import org.apache.commons.lang3.StringUtils;

public class Result<T> {
    private static final String MSG_PREFIX = "MSG";
    private String code;
    private String message;
    private T result;

    public Result() {
    }

    public Result(ResultCode responseCode) {
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public Result(T result, ResultCode responseCode) {
        this.result = result;
        this.code = responseCode.getCode();
        this.message = responseCode.getMessage();
    }

    public static <T> Result<T> ok(T body) {
        Result<T> response = new Result<T>();
        response.setResult(body);
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public static <T> Result<T> ok() {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.OK.getCode());
        response.setMessage(ResultCode.OK.getMessage());
        return response;
    }

    public static <T> Result<T> invalidParam(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.INVALID_PARAM.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INVALID_PARAM.getMessage() : message);
        return response;
    }

    public static <T> Result<T> noData(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.NO_DATA.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.NO_DATA.getMessage() : message);
        return response;
    }

    public static <T> Result<T> serverError(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.INTERNAL_SERVER_ERROR.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INTERNAL_SERVER_ERROR.getMessage() : message);
        return response;
    }

    public static <T> Result<T> invocationTimeout(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.INVOCATION_TIMEOUT.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INVOCATION_TIMEOUT.getMessage() : message);
        return response;
    }

    public static <T> Result<T> invocationError(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.INVOCATION_ERROR.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.INVOCATION_ERROR.getMessage() : message);
        return response;
    }

    public static <T> Result<T> rateLimit(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.RATE_LIMIT_ERROR.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.RATE_LIMIT_ERROR.getMessage() : message);
        return response;
    }

    public static <T> Result<T> accessDeny(String message) {
        Result<T> response = new Result<T>();
        response.setCode(ResultCode.ACCESS_DENIED.getCode());
        response.setMessage(StringUtils.isEmpty((CharSequence)message) ? ResultCode.ACCESS_DENIED.getMessage() : message);
        return response;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public static enum ResultCode {
        OK("1", "\u5904\u7406\u6210\u529f"),
        INVALID_PARAM("MSGCZZ1001", "\u975e\u6cd5\u53c2\u6570"),
        EMPTY_PARAM("MSGCZZ1002", "\u53c2\u6570\u4e3a\u7a7a"),
        MISSING_PARAM("MSGCZZ1003", "\u53c2\u6570\u7f3a\u5931"),
        NO_DATA("MSGCZZ1010", "\u67e5\u8be2\u4e0d\u5230\u8be5\u8bb0\u5f55"),
        EXISTING_DATA("MSGCZZ1011", "\u8bb0\u5f55\u5df2\u5b58\u5728"),
        NOT_LOGIN("MSGCZZ2001", "\u7528\u6237\u672a\u767b\u5f55\uff0c\u8bbf\u95ee\u8def\u5f84\u9700\u8981\u9a8c\u8bc1"),
        LOGIN_FAILED("MSGCZZ2002", "\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef"),
        DISABLED_ACCOUNT("MSGCZZ2003", "\u8d26\u53f7\u88ab\u7981\u7528"),
        USER_NOT_EXISTS("MSGCZZ2004", "\u7528\u6237\u4e0d\u5b58\u5728"),
        EXISTS_USER("MSGCZZ2005", "\u7528\u6237\u5df2\u7ecf\u5b58\u5728"),
        ACCESS_DENIED("MSGCZZ2006", "\u8bbf\u95ee\u62d2\u7edd"),
        INTERNAL_SERVER_ERROR("MSGCZZ3001", "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"),
        CONCURRENCY_ERROR("MSGCZZ3002", "\u591a\u7ebf\u7a0b\u5e76\u53d1\u6267\u884c\u9519\u8bef"),
        INVOCATION_TIMEOUT("MSGCZZ3003", "\u7b2c\u4e09\u65b9\u8c03\u7528\u8d85\u65f6"),
        INVOCATION_ERROR("MSGCZZ3004", "\u7b2c\u4e09\u65b9\u8c03\u7528\u5f02\u5e38"),
        RATE_LIMIT_ERROR("MSGCZZ3005", "\u670d\u52a1\u9650\u6d41");

        private final String code;
        private final String message;

        private ResultCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

