package com.xforceplus.janus.message.sdk.core;

import java.util.Map;
import java.util.UUID;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:46 AM
 **/
public abstract class AbsMbRequest<T extends AbsMbResponse> {

    public abstract String httpMethod();

    public abstract String getParamJson();

    public abstract Map<String, String> getParam();

    public abstract String getRequestPath();

    public abstract Class<T> getResponseClass();


    private Map<String, String> headers;

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String requestId() {
        return UUID.randomUUID().toString();
    }
}
