package com.xforceplus.janus.message.sdk;


import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 请求消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/

/**
 * 请求消息
 */
public class RequestMessage implements Serializable {

    public static final String BUSINESS_NO_POP = "businessNo";

    //消息内容 JSON
    private String content;

    //消息属性Map
    private Map<String, String> properties;

    //发送时间戳，用来记录生产者发送消息时间点
    private long sentTime;

    //生产者发送成功后回调地址
    private String callbackUrl;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, String> getProperties() {
        if (MapUtils.isEmpty(properties)) {
            properties = new HashMap<>();
        }
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getSentTime() {
        return sentTime;
    }

    public void setSentTime(long sentTime) {
        this.sentTime = sentTime;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setBuinessNo(String businessNo) {
        getProperties().put(BUSINESS_NO_POP, businessNo);
    }
}
