/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.sdk;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.request.AckRequest;
import com.xforceplus.janus.message.sdk.request.PubRequest;
import com.xforceplus.janus.message.sdk.request.SubRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;
import com.xforceplus.janus.message.sdk.response.PubResponse;
import com.xforceplus.janus.message.sdk.response.SubResponse;
import com.xforceplus.janus.message.sdk.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBClient {
    static Logger log = LoggerFactory.getLogger(MBClient.class);
    private final Integer MAX_THREAD_NUM = 2;
    final Semaphore semaphore = new Semaphore(this.MAX_THREAD_NUM);
    private String url;
    private String token;
    private Integer threadNum = 1;

    private MBClient() {
    }

    public static MBClient getInstance(String url, String token) {
        MBClient mbClient = SingletonClassInstance.instance;
        if (Objects.isNull(mbClient.getUrl()) || "".equals(mbClient.getUrl())) {
            mbClient.setUrl(url);
            mbClient.setToken(token);
        }
        return mbClient;
    }

    public PubResponse pub(PubRequest request) {
        PubResponse response = new PubResponse();
        try {
            response = PubResponse.transform(this.exec(request));
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setSuccess(false);
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubResponse sub() {
        SubResponse response = new SubResponse();
        try {
            this.semaphore.acquire();
            SubRequest request = new SubRequest();
            response = SubResponse.transform(this.exec(request));
            if (!response.getSuccess().booleanValue() || response.getSuccess().booleanValue() && CollectionUtils.isEmpty(response.getResponseMessages())) {
                TimeUnit.SECONDS.sleep(3L);
            }
            SubResponse subResponse = response;
            return subResponse;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.semaphore.release();
        }
        response.setSuccess(false);
        return response;
    }

    public AckResponse ack(AckRequest request) {
        AckResponse response = new AckResponse();
        try {
            response = AckResponse.transform(this.exec(request));
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setSuccess(false);
            return response;
        }
    }

    private HttpResp exec(AbsMbRequest request) {
        String url = this.getUrl() + request.getRequestPath();
        Map<String, String> headers = request.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("MB_TOKEN", this.getToken());
        headers.put("content-type", "application/json");
        headers.put("CLIENT_VERSION", "1.0.6.21");
        String requestId = request.requestId();
        headers.put("CLIENT_REQUEST_ID", requestId);
        log.info("requestId[{}]\u603b\u7ebf\u8bf7\u6c42\u5185\u5bb9[{}]", new Object[]{requestId, request.getRequestPath(), JacksonUtil.getInstance().toJson((Object)request)});
        HttpResp resp = null;
        if ("get".equals(request.httpMethod())) {
            resp = HttpUtils.getRequest(url, headers, request.getParam());
        } else if ("post".equals(request.httpMethod())) {
            resp = HttpUtils.postRequest(url, headers, request.getParamJson());
        } else if ("put".equals(request.httpMethod())) {
            resp = HttpUtils.putRequest(url, headers, request.getParamJson());
        }
        log.info("requestId[{}]\u8c03\u7528\u7ed3\u675fresponse[{}]", (Object)requestId, (Object)JacksonUtil.getInstance().toJson((Object)resp));
        return resp;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(Integer threadNum) {
        if (threadNum > this.MAX_THREAD_NUM) {
            log.warn("\u6700\u5927\u652f\u6301[{}]\u4e2a\u7ebf\u7a0b");
            threadNum = this.MAX_THREAD_NUM;
        }
        this.threadNum = threadNum;
    }

    private static class SingletonClassInstance {
        private static final MBClient instance = new MBClient();

        private SingletonClassInstance() {
        }
    }
}

