package com.xforceplus.janus.message.sdk;

import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.core.HttpResp;
import com.xforceplus.janus.message.sdk.request.AddSubRuleRequest;
import com.xforceplus.janus.message.sdk.request.DeleteSubRuleRequest;
import com.xforceplus.janus.message.sdk.request.ListSubRuleRequest;
import com.xforceplus.janus.message.sdk.response.AddSubRuleResponse;
import com.xforceplus.janus.message.sdk.response.DeleteSubRuleResponse;
import com.xforceplus.janus.message.sdk.response.ListSubRuleResponse;
import com.xforceplus.janus.message.sdk.utils.HttpUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:37 AM
 **/
public class MBAdminClient {

    private String url;

    private static class SingletonClassInstance {
        private static final MBAdminClient instance = new MBAdminClient();
    }

    private MBAdminClient() {
    }

    public static MBAdminClient getInstance(String url) {
        MBAdminClient mbClient = SingletonClassInstance.instance;
        if (Objects.isNull(mbClient.getUrl()) || "".equals(mbClient.getUrl())) {
            mbClient.setUrl(url);
        }

        return mbClient;
    }

    public ListSubRuleResponse listSubRule(ListSubRuleRequest request) {
        return ListSubRuleResponse.transform(exec(request));
    }

    public AddSubRuleResponse addSubRule(AddSubRuleRequest request) {
        return AddSubRuleResponse.transform(exec(request));
    }

    public DeleteSubRuleResponse deleteSubRule(DeleteSubRuleRequest request) {
        return DeleteSubRuleResponse.transform(exec(request));
    }

    public HttpResp exec(AbsMbRequest request) {
        String url = getUrl() + request.getRequestPath();
        Map<String, String> headers = request.getHeaders();
        if (headers == null) {
            headers = new HashMap<>();
        }
        headers.put(Constants.MB_HEADER_CONTENT_TYPE, "application/json");
        headers.put(Constants.MB_HEADER_CLIENT_VERSION, Constants.CLIENT_VERSION);

        if (Constants.HTTP_METHOD_GET.equals(request.httpMethod())) {
            return HttpUtils.getRequest(url, headers, request.getParam());
        }
        if (Constants.HTTP_METHOD_POST.equals(request.httpMethod())) {
            return HttpUtils.postRequest(url, headers, request.getParamJson());
        }
        if (Constants.HTTP_METHOD_PUT.equals(request.httpMethod())) {
            return HttpUtils.putRequest(url, headers, request.getParamJson());
        }

        return null;

    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
