package com.xforceplus.janus.message.sdk.request;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.sdk.Constants;
import com.xforceplus.janus.message.sdk.core.AbsMbRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:41 AM
 **/
public class AckRequest extends AbsMbRequest<AckResponse> {

    private List<String> receiptHandles;

    public AckRequest(List<String> receiptHandles) {
        this.receiptHandles = receiptHandles;
    }

    @Override
    public String httpMethod() {
        return Constants.HTTP_METHOD_PUT;
    }

    @Override
    public String getParamJson() {
        Map<String, List<String>> map = new HashMap<>();
        map.put("receiptHandles", this.getReceiptHandles());
        return JacksonUtil.getInstance().toJson(map);
    }

    @Override
    public Map<String, String> getParam() {
        return null;
    }

    @Override
    public String getRequestPath() {
        return Constants.MB_REQUEST_PATH_ACK;
    }

    @Override
    public Class<AckResponse> getResponseClass() {
        return AckResponse.class;
    }

    public List<String> getReceiptHandles() {
        return receiptHandles;
    }

    public void setReceiptHandles(List<String> receiptHandles) {
        this.receiptHandles = receiptHandles;
    }
}
