package com.xforceplus.janus.message.sdk.enums;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/5/10 9:02 PM
 **/
public enum  AttrTypeEnum {


    NUMBER("number", "数字"),

    STRING("string", "字符串"),

            ;

    private String code;

    private String desc;

    AttrTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Object convert(String attrVal, String attrType) {
        if (Objects.isNull(attrType)) {
            return attrVal;
        }
        AttrTypeEnum typeEnum = getByCode(attrType);
        if (NUMBER.equals(typeEnum)) {
            return new BigDecimal(attrVal);
        }

        if (STRING.equals(typeEnum)) {
            return attrVal;
        }

        return attrVal;
    }

    public static AttrTypeEnum getByCode(String code) {
        for (AttrTypeEnum typeEnum : AttrTypeEnum.values()) {
            if (typeEnum.getCode().toUpperCase().equals(code.toUpperCase())) {
                return typeEnum;
            }
        }
        throw new IllegalArgumentException("属性类型错误");
    }
}
