package com.xforceplus.janus.message.monitor;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executors;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/2/2 10:06 AM
 **/
@Slf4j
@Component
public class MonitorBus {

    @Autowired
    private MessageStatisticsEventHandler statisticsEventHandler;

    Disruptor<MessageStatisticsEvent> disruptor = new Disruptor<>(
            MessageStatisticsEvent::new,
            1024,
            Executors.defaultThreadFactory(),
            ProducerType.SINGLE,
            new YieldingWaitStrategy()
    );

    {
        disruptor.handleEventsWith(statisticsEventHandler);
        disruptor.start();
    }

    public void addStatistics(MessageStatistics statistics) {
        RingBuffer<MessageStatisticsEvent> ringBuffer = disruptor.getRingBuffer();
        MessageStatisticsProducer eventProducer = new MessageStatisticsProducer(ringBuffer);
        eventProducer.onData(statistics);
    }
}