/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.monitor;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WorkHandler;
import com.xforceplus.janus.message.core.service.IMessageTraceService;
import com.xforceplus.janus.message.entity.MessageTrace;
import com.xforceplus.janus.message.monitor.MessageStatistics;
import com.xforceplus.janus.message.monitor.MessageStatisticsEvent;
import com.xforceplus.janus.message.uitls.UniqIdUtils;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageStatisticsEventHandler
implements EventHandler<MessageStatisticsEvent>,
WorkHandler<MessageStatisticsEvent> {
    private static final Logger log = LoggerFactory.getLogger(MessageStatisticsEventHandler.class);
    @Autowired
    IMessageTraceService messageTraceService;

    public void onEvent(MessageStatisticsEvent event, long sequence, boolean endOfBatch) throws Exception {
        MessageTrace messageTrace = new MessageTrace();
        MessageStatistics statistics = event.getMessageStatistics();
        String idStr = UniqIdUtils.getInstance().getUniqID();
        messageTrace.setMessageId(statistics.getMessageId());
        messageTrace.setMessageId(statistics.getMessageId());
        messageTrace.setId(Long.valueOf(idStr));
        messageTrace.setCreatedTime(Instant.now());
        log.info("event: {}, sequence: {}, endOfBatch: {}", new Object[]{event, sequence, endOfBatch});
        this.messageTraceService.save((Object)messageTrace);
    }

    public void onEvent(MessageStatisticsEvent event) throws Exception {
        log.info("event: {}", (Object)event);
    }
}

