/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.monitor;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.xforceplus.janus.message.monitor.MessageStatistics;
import com.xforceplus.janus.message.monitor.MessageStatisticsEvent;
import com.xforceplus.janus.message.monitor.MessageStatisticsEventHandler;
import com.xforceplus.janus.message.monitor.MessageStatisticsProducer;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorBus {
    private static final Logger log = LoggerFactory.getLogger(MonitorBus.class);
    @Autowired
    private MessageStatisticsEventHandler statisticsEventHandler;
    Disruptor<MessageStatisticsEvent> disruptor = new Disruptor(MessageStatisticsEvent::new, 1024, Executors.defaultThreadFactory(), ProducerType.SINGLE, (WaitStrategy)new YieldingWaitStrategy());

    public MonitorBus() {
        this.disruptor.handleEventsWith(new EventHandler[]{this.statisticsEventHandler});
        this.disruptor.start();
    }

    public void addStatistics(MessageStatistics statistics) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        MessageStatisticsProducer eventProducer = new MessageStatisticsProducer((RingBuffer<MessageStatisticsEvent>)ringBuffer);
        eventProducer.onData(statistics);
    }
}

