package com.xforceplus.janus.message.monitor;

import com.lmax.disruptor.RingBuffer;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/2/5 11:32 AM
 **/
public class MessageStatisticsProducer {

    private final RingBuffer<MessageStatisticsEvent> ringBuffer;

    public MessageStatisticsProducer(RingBuffer<MessageStatisticsEvent> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void onData(MessageStatistics messageStatistics) {
        long sequence = ringBuffer.next();
        try {
            MessageStatisticsEvent event = ringBuffer.get(sequence);
            event.setMessageStatistics(messageStatistics);
        } finally {
            ringBuffer.publish(sequence);
        }
    }
}
