package com.xforceplus.janus.message.msg.core;

import com.xforceplus.janus.message.common.dto.api.TemplateParamMappingRuleDTO;
import com.xforceplus.janus.message.common.dto.sms.ChannelMsgDto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消息发送
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/21 1:57 PM
 **/
public abstract class AbsMsgSend {

    public static Map<String, AbsMsgSend> channel2MsgSend = new HashMap<>();

    {
        channel2MsgSend.put(getChannelCode(), this);
    }

    /**
     * 发送消息
     *
     * @param content 消息内容
     * @param to      给谁：手机号、邮箱、MQ对应的topicName、微信openId、钉钉Id等
     */
    public abstract void send(String content, String to);

    /**
     * 发送消息
     *
     * @param content 消息内容
     * @param tos     给谁：手机号、邮箱、MQ对应的topicName、微信openId、钉钉Id等
     */
    public abstract void send(String content, List<String> tos);

    public abstract void send(ChannelMsgDto channelMsgDto, List<String> tos);

    /**
     * 根据模板发送消息
     *
     * @param templateId    模板ID
     * @param originMessage       消息
     * @param templateParamMappingRuleDTOS 模板参数根据message的映射关系
     * @param tos           给谁：手机号、邮箱、MQ对应的topicName、微信openId、钉钉Id等
     */
    public abstract void sendByTemplate(String templateId, String originMessage, List<TemplateParamMappingRuleDTO> templateParamMappingRuleDTOS, List<String> tos);

    public abstract String getChannelCode();
}
