package com.xforceplus.janus.message.msg.core;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;

import com.xforceplus.janus.message.common.dto.api.TemplateParamMappingRuleDTO;
import com.xforceplus.janus.message.common.enums.CacheKey;
import com.xforceplus.janus.message.core.cache.XRedisCacheUtil;
import com.xforceplus.janus.message.core.service.IChannelService;
import com.xforceplus.janus.message.entity.Channel;
import com.xforceplus.janus.message.common.dto.sms.ChannelMsgDto;
import com.xforceplus.janus.message.common.utils.MappingUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.client.RestTemplate;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/2/20 5:14 PM
 **/
@Component
@Slf4j
public class ChannelMessageSend {

    @Autowired
    private IChannelService channelService;

    @Autowired
    private XRedisCacheUtil cacheUtil;

    public void send(String channel, String content, String to) {
        this.send(channel, content, Lists.newArrayList(to));
    }

    public void send(String channel, String content, List<String> tos) {
        ChannelMsgDto channelMsgDto = new ChannelMsgDto();
        channelMsgDto.setTemplateId("");
        channelMsgDto.setContent(content);
        channelMsgDto.setParamVals(null);
        channelMsgDto.setTos(tos);

        this.send(channel, channelMsgDto);
    }

    //调用渠道API
    public void send(String channel, ChannelMsgDto channelMsgDto) {
        String cacheKey = CacheKey.getChannelConfigKey(channel);
        String cacheVal = XRedisCacheUtil.StringOps.get(cacheKey);
        if (StringUtils.isEmpty(cacheVal)) {
            initAllChannelConfigCache(channelService.queryAllValid());
        }
        cacheVal = XRedisCacheUtil.StringOps.get(cacheKey);
        // TODO: 2021/2/22  调用量非常大的情况，请考虑使用本地缓存
        Channel entity = JSON.parseObject(cacheVal, Channel.class);
        String url = entity.getApiUrl();
        String requestBody = JSON.toJSONString(channelMsgDto);
        log.info("call channel api start : url [{}] , content [{}]", url, requestBody);
        new RestTemplate().postForObject(url, channelMsgDto, Object.class);
    }

    public void sendByTemplate(String channel, String templateId, String originMessage, List<TemplateParamMappingRuleDTO> templateParamMappingRuleDTOS, List<String> tos) {
        Map<String, String> templateVariables = MappingUtil.transform(originMessage, templateParamMappingRuleDTOS);

        ChannelMsgDto channelMsgDto = new ChannelMsgDto();
        channelMsgDto.setTemplateId(templateId);
        channelMsgDto.setContent("");
        channelMsgDto.setParamVals(templateVariables);
        channelMsgDto.setTos(tos);

        this.send(channel, channelMsgDto);

    }

    private void initAllChannelConfigCache(List<Channel> channels) {
        for (Channel c : channels) {
            String cKey = CacheKey.getChannelConfigKey(c.getCode());
            String cVal = JSON.toJSONString(c);
            XRedisCacheUtil.StringOps.set(cKey, cVal);
        }
    }

}
