package com.xforceplus.janus.message.msg.core;

import com.alibaba.fastjson.JSON;
import com.aliyun.mq.http.model.Message;
import com.xforceplus.janus.message.common.dto.api.EventChannelSettingDTO;
import com.xforceplus.janus.message.common.enums.XMessageMQTypeEnum;
import com.xforceplus.janus.message.core.cache.EventConfigCacheMgr;
import com.xforceplus.janus.message.core.mq.XMessageProcessor;
import com.xforceplus.janus.message.core.mq.XMessage;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * 渠道消息发送-MQ消费者
 *
 * @author zhujie@xforceplus.com
 * @date 2021/2/1 2:36 PM
 **/
@Component("channelMsgProcessor")
@Slf4j
public class ChannelMsgProcessor implements XMessageProcessor {

    @Autowired
    private EventConfigCacheMgr eventConfigMgr;

    @Autowired
    private ChannelMessageSend channelMessageSend;

    @Override
    public void process(XMessage message) throws Exception {
        if (message.getMqType().equals(XMessageMQTypeEnum.ROCKET_MQ.getCode())) {
            com.xforceplus.janus.message.entity.Message originMessage = JSON.parseObject(new String(((Message) message.getMqMsg()).getMessageBodyBytes()), com.xforceplus.janus.message.entity.Message.class);
            System.out.println("==============");
            System.out.println("==============");
            System.out.println("==============");


            List<EventChannelSettingDTO> channelConfigs = eventConfigMgr.getChannelConfigByBusinessCode(originMessage.getPubCode());
            for (EventChannelSettingDTO channelSettingDTO : channelConfigs) {
                channelMessageSend.sendByTemplate(channelSettingDTO.getChannel(), channelSettingDTO.getChannelTemplateId(), originMessage.getMessageBody(), channelSettingDTO.getTemplateParamMappingRule(), channelSettingDTO.getTos());
            }
        }
    }
}
