package com.xforceplus.janus.message.msg.core;

import com.xforceplus.janus.message.common.dto.ResponseMessage;
import com.xforceplus.janus.message.common.dto.api.EventChannelSettingDTO;
import com.xforceplus.janus.message.core.mq.XMessageProcessor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * 渠道消息发送-MQ消费者
 *
 * @author zhujie@xforceplus.com
 * @date 2021/2/1 2:36 PM
 **/
@Component("channelMsgProcessor")
@Slf4j
public class ChannelMsgProcessor implements XMessageProcessor {

    Map<String, List<EventChannelSettingDTO>> subCode2ChannelSetting = new HashMap<>();

    public void add(String subCode, List<EventChannelSettingDTO> eventChannelSettingDTOS) {
        subCode2ChannelSetting.put(subCode, eventChannelSettingDTOS);
    }

    @Autowired
    private ChannelMessageSend channelMessageSend;

    @Override
    public void process(ResponseMessage message) throws Exception {
        System.out.println("发送渠道消息==============");
        System.out.println("发送渠道消息==============");
        System.out.println("发送渠道消息==============");

        List<EventChannelSettingDTO> channelConfigs = subCode2ChannelSetting.get(message.getSubCode());

        for (EventChannelSettingDTO channelSettingDTO : channelConfigs) {
            channelMessageSend.sendByTemplate(channelSettingDTO.getChannel(), channelSettingDTO.getChannelTemplateId(), message.getContent(), channelSettingDTO.getTemplateParamMappingRule(), channelSettingDTO.getTos());
        }
    }
}
