/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.msg.core;

import com.google.common.collect.Lists;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.common.dto.api.TemplateParamMappingRuleDTO;
import com.xforceplus.janus.message.common.dto.sms.ChannelMsgDto;
import com.xforceplus.janus.message.common.enums.CacheKey;
import com.xforceplus.janus.message.common.utils.MappingUtil;
import com.xforceplus.janus.message.core.cache.XRedisCacheUtil;
import com.xforceplus.janus.message.core.service.IChannelService;
import com.xforceplus.janus.message.entity.Channel;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelMessageSend {
    private static final Logger log = LoggerFactory.getLogger(ChannelMessageSend.class);
    @Autowired
    private IChannelService channelService;
    @Autowired
    private XRedisCacheUtil cacheUtil;

    public void send(String channel, String content, String to) {
        this.send(channel, content, Lists.newArrayList((Object[])new String[]{to}));
    }

    public void send(String channel, String content, List<String> tos) {
        ChannelMsgDto channelMsgDto = new ChannelMsgDto();
        channelMsgDto.setTemplateId("");
        channelMsgDto.setContent(content);
        channelMsgDto.setParamVals(null);
        channelMsgDto.setTos(tos);
        this.send(channel, channelMsgDto);
    }

    public void send(String channel, ChannelMsgDto channelMsgDto) {
        String cacheKey = CacheKey.getChannelConfigKey((String)channel);
        String cacheVal = XRedisCacheUtil.StringOps.get((String)cacheKey);
        if (StringUtils.isEmpty((CharSequence)cacheVal)) {
            this.initAllChannelConfigCache(this.channelService.queryAllValid());
        }
        cacheVal = XRedisCacheUtil.StringOps.get((String)cacheKey);
        Channel entity = (Channel)JacksonUtil.getInstance().fromJson(cacheVal, Channel.class);
        String url = entity.getApiUrl();
        String requestBody = JacksonUtil.getInstance().toJson((Object)channelMsgDto);
        log.info("call channel api start : url [{}] , content [{}]", (Object)url, (Object)requestBody);
        log.info("call channel api start : url [{}] , content [{}]", (Object)url, (Object)requestBody);
        log.info("call channel api start : url [{}] , content [{}]", (Object)url, (Object)requestBody);
    }

    public void sendByTemplate(String channel, String templateId, String originMessage, List<TemplateParamMappingRuleDTO> templateParamMappingRuleDTOS, List<String> tos) {
        Map templateVariables = MappingUtil.transform((String)originMessage, templateParamMappingRuleDTOS);
        ChannelMsgDto channelMsgDto = new ChannelMsgDto();
        channelMsgDto.setTemplateId(templateId);
        channelMsgDto.setContent("");
        channelMsgDto.setParamVals(templateVariables);
        channelMsgDto.setTos(tos);
        this.send(channel, channelMsgDto);
    }

    private void initAllChannelConfigCache(List<Channel> channels) {
        for (Channel c : channels) {
            String cKey = CacheKey.getChannelConfigKey((String)c.getCode());
            String cVal = JacksonUtil.getInstance().toJson((Object)c);
            XRedisCacheUtil.StringOps.set((String)cKey, (String)cVal);
        }
    }
}

