package com.xforceplus.janus.message.timed.eventflow;

import com.alibaba.fastjson.JSON;
import com.xforceplus.janus.message.common.dto.api.EventNodeConfigDelayDTO;
import com.xforceplus.janus.message.common.enums.Constants;
import com.xforceplus.janus.message.common.enums.DelayMessageStatusEnum;
import com.xforceplus.janus.message.common.enums.NodeTypeEnum;
import com.xforceplus.janus.message.core.service.IMessageDelayService;
import com.xforceplus.janus.message.entity.Message;
import com.xforceplus.janus.message.entity.MessageDelay;
import com.xforceplus.janus.message.event.flow.core.AbsNodeExecutor;
import com.xforceplus.janus.message.uitls.UniqIdUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 5:08 PM
 **/
@Service
@Slf4j
public class DelayExecutor extends AbsNodeExecutor {

    @Autowired
    private IMessageDelayService messageDelayService;

    @Override
    public String getNodeType() {
        return NodeTypeEnum.DELAY.getCode();
    }

    @Override
    public void process() throws Exception {
        EventNodeConfigDelayDTO nodeConfig = JSON.parseObject(JSON.toJSONString(getCurrNode().getConfig()), EventNodeConfigDelayDTO.class);
        long timeStamp = System.currentTimeMillis() + nodeConfig.getMillisecond();

        System.out.println("===========" + getNodeType());
        System.out.println("===========" + JSON.toJSONString(getSlot().getRequestData()));
        Message originMessage = getSlot().getRequestData();
        MessageDelay messageDelay = new MessageDelay();
        messageDelay.setId(UniqIdUtils.getInstance().getUniqID());
//        messageDelay.setAppId(originMessage.getAppId());
        messageDelay.setMessageId(originMessage.getId().toString());
        messageDelay.setEventId(originMessage.getPubCode());
        messageDelay.setStatus(DelayMessageStatusEnum.WAIT_SEND.getCode());
        messageDelay.setIsValid(Constants.IS_VALIDED);
        messageDelay.setIsLock(Constants.IS_NOT_LOCKED);
        LocalDateTime ldt = new Date(timeStamp).toInstant()
                .atZone(ZoneId.systemDefault())
                .toLocalDateTime();
        messageDelay.setSendTime(ldt);
        messageDelay.setCreator("0");
        messageDelay.setCreatedTime(Instant.now());
        messageDelay.setModifier("0");
        messageDelay.setModifiedTime(Instant.now());
        messageDelayService.save(messageDelay);
    }

}
