package com.xforceplus.janus.message.timed.eventflow;

import com.xforceplus.janus.message.common.enums.Constants;
import com.xforceplus.janus.message.common.enums.NodeTypeEnum;
import com.xforceplus.janus.message.core.service.IMessageTaskService;
import com.xforceplus.janus.message.entity.Message;
import com.xforceplus.janus.message.entity.MessageTask;
import com.xforceplus.janus.message.event.flow.core.AbsNodeExecutor;
import com.xforceplus.janus.message.uitls.UniqIdUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import lombok.extern.slf4j.Slf4j;

import java.time.Instant;

/**
 * https://blog.csdn.net/NothingToSay01/article/details/78469504
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/14 5:08 PM
 **/
@Service
@Slf4j
public class TimedTaskExecutor extends AbsNodeExecutor {

    @Autowired
    private IMessageTaskService messageTaskService;

    @Override
    public String getNodeType() {
        return NodeTypeEnum.TASK.getCode();
    }

    @Override
    public void process() throws Exception {
        System.out.println("===========" + getNodeType());
        Message originMessage = getSlot().getRequestData();
        MessageTask messageTask = new MessageTask();
        messageTask.setId(UniqIdUtils.getInstance().getUniqID());
//        messageTask.setAppId(originMessage.getAppId());
//        messageTask.setMessageId(originMessage.getMqMsgId());
//        messageTask.setEventId(originMessage.getEventId());
        messageTask.setIsValid(Constants.IS_VALIDED);
        messageTask.setIsLock(Constants.IS_NOT_LOCKED);
        messageTask.setCreator("0");
        messageTask.setCreatedTime(Instant.now());
        messageTask.setModifier("0");
        messageTask.setModifiedTime(Instant.now());
        messageTaskService.save(messageTask);
    }
}
