/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.timed.eventflow;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.common.dto.api.EventNodeConfigDelayDTO;
import com.xforceplus.janus.message.common.enums.DelayMessageStatusEnum;
import com.xforceplus.janus.message.core.service.IMessageDelayService;
import com.xforceplus.janus.message.entity.Message;
import com.xforceplus.janus.message.entity.MessageDelay;
import com.xforceplus.janus.message.event.flow.core.AbsNodeExecutor;
import com.xforceplus.janus.message.uitls.UniqIdUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DelayExecutor
extends AbsNodeExecutor {
    private static final Logger log = LoggerFactory.getLogger(DelayExecutor.class);
    @Autowired
    private IMessageDelayService messageDelayService;

    public String getNodeType() {
        return "";
    }

    public void process() throws Exception {
        EventNodeConfigDelayDTO nodeConfig = (EventNodeConfigDelayDTO)JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(this.getCurrNode().getConfig()), EventNodeConfigDelayDTO.class);
        long timeStamp = System.currentTimeMillis() + nodeConfig.getMillisecond();
        System.out.println("===========" + this.getNodeType());
        System.out.println("===========" + JacksonUtil.getInstance().toJson(this.getSlot().getRequestData()));
        Message originMessage = (Message)this.getSlot().getRequestData();
        MessageDelay messageDelay = new MessageDelay();
        messageDelay.setId(UniqIdUtils.getInstance().getUniqID());
        messageDelay.setMessageId(originMessage.getId().toString());
        messageDelay.setEventId(originMessage.getPubCode());
        messageDelay.setStatus(DelayMessageStatusEnum.WAIT_SEND.getCode());
        messageDelay.setIsValid(Integer.valueOf(1));
        messageDelay.setIsLock(Integer.valueOf(0));
        LocalDateTime ldt = new Date(timeStamp).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        messageDelay.setSendTime(ldt);
        messageDelay.setCreator("0");
        messageDelay.setCreatedTime(Instant.now());
        messageDelay.setModifier("0");
        messageDelay.setModifiedTime(Instant.now());
        this.messageDelayService.save((Object)messageDelay);
    }
}

