package com.xforceplus.janus.message.timed.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/25 11:20 AM
 **/
@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "job")
@Getter
@Setter
public class XXLJobPropertie {

    private String auth;

    private String alarmEmail;

    private String serverUrl;

    private String callbackUrl;

    private String groupAppName;

    private String groupTitle;

    private String user;

    private String password;

    private String glueType;        // GLUE类型	#com.xxl.job.core.glue.GlueTypeEnum

    private String executorRouteStrategy;    // 执行器路由策略

    private String executorHandler;            // 执行器，任务Handler名称

    private String executorParamUrl;            // 执行器，任务参数

    private String executorParamMthod;            // 执行器，任务参数

    private String executorBlockStrategy;    // 阻塞处理策略

    private int executorTimeout;            // 任务执行超时时间，单位秒

    private int executorFailRetryCount;        // 失败重试次数

    private Delayjob delayjob;

    public static class Delayjob {
        private String cron;

        private String jobDesc;

        private String executorParamUrl;            // 执行器，任务参数

        private String executorParamMthod;            // 执行器，任务参数

        public String getCron() {
            return cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public String getJobDesc() {
            return jobDesc;
        }

        public void setJobDesc(String jobDesc) {
            this.jobDesc = jobDesc;
        }

        public String getExecutorParamUrl() {
            return executorParamUrl;
        }

        public void setExecutorParamUrl(String executorParamUrl) {
            this.executorParamUrl = executorParamUrl;
        }

        public String getExecutorParamMthod() {
            return executorParamMthod;
        }

        public void setExecutorParamMthod(String executorParamMthod) {
            this.executorParamMthod = executorParamMthod;
        }
    }

}
