package com.xforceplus.janus.message.timed.core;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.message.common.dto.api.EventNodeConfigTimedDTO;
import com.xforceplus.janus.message.common.dto.xxljob.HttpExecuteParam;
import com.xforceplus.janus.message.common.dto.xxljob.XXLJobResult;
import com.xforceplus.janus.message.common.dto.xxljob.XxlJobGroup;
import com.xforceplus.janus.message.common.dto.xxljob.XxlJobInfo;
import com.xforceplus.janus.message.timed.config.XXLJobPropertie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/25 11:28 AM
 **/
@Service
@Slf4j
public class XXLJobService {

    @Autowired
    private XXLJobPropertie jobPropertie;

    XxlJobGroup xxlJobGroup;

    Map<String, String> headers = new HashMap<>();


    public XXLJobService(XXLJobPropertie xxlJobPropertie) {
        this.jobPropertie = xxlJobPropertie;
    }

    private volatile boolean init = false;

//    @PostConstruct
    public void init() {
//        log.info("xxl-job init");
//        log.info("xxl-job init");
//        log.info("xxl-job init");
//        headers.put("XXL-JOB-ACCESS-TOKEN", "message-center");
//
//        new Thread(() -> {
//            initDelayJob();
//        }).start();

    }


    public void initDelayJob() {
        try {
            xxlJobGroup = getGroup(jobPropertie.getGroupAppName());
            if (xxlJobGroup == null) {
                log.error("没有初始化group：{}", jobPropertie.getGroupAppName());
                throw new IllegalStateException("没有初始化group");
            }
            XxlJobInfo xxlJobInfo = getJob(xxlJobGroup.getId(), jobPropertie.getDelayjob().getJobDesc());
            HttpExecuteParam executeParam = new HttpExecuteParam();
            executeParam.setUrl(jobPropertie.getDelayjob().getExecutorParamUrl());
            executeParam.setMethod(jobPropertie.getDelayjob().getExecutorParamMthod());
            boolean result = false;
            if (xxlJobInfo == null) {
                XxlJobInfo jobInfo = new XxlJobInfo();
                jobInfo.setJobGroup(xxlJobGroup.getId());
                jobInfo.setJobCron(jobPropertie.getDelayjob().getCron());
                jobInfo.setJobDesc(jobPropertie.getDelayjob().getJobDesc());
                jobInfo.setAddTime(new Date());
                jobInfo.setUpdateTime(new Date());
                jobInfo.setAuthor(jobPropertie.getAuth());
                jobInfo.setAlarmEmail(jobPropertie.getAlarmEmail());
                jobInfo.setExecutorRouteStrategy(jobPropertie.getExecutorRouteStrategy());
                jobInfo.setExecutorHandler(jobPropertie.getExecutorHandler());
                jobInfo.setTriggerStatus(1);
                jobInfo.setExecutorParam(JacksonUtil.getInstance().toJson(executeParam));
                jobInfo.setExecutorBlockStrategy(jobPropertie.getExecutorBlockStrategy());
                jobInfo.setExecutorTimeout(jobPropertie.getExecutorTimeout());
                jobInfo.setExecutorFailRetryCount(jobPropertie.getExecutorFailRetryCount());
                jobInfo.setGlueType(jobPropertie.getGlueType());

                result = addJob(jobInfo);

            } else {
                xxlJobInfo.setJobGroup(xxlJobGroup.getId());
                xxlJobInfo.setJobCron(jobPropertie.getDelayjob().getCron());
                xxlJobInfo.setJobDesc(jobPropertie.getDelayjob().getJobDesc());
                xxlJobInfo.setAddTime(new Date());
                xxlJobInfo.setUpdateTime(new Date());
                xxlJobInfo.setAuthor(jobPropertie.getAuth());
                xxlJobInfo.setAlarmEmail(jobPropertie.getAlarmEmail());
                xxlJobInfo.setExecutorRouteStrategy(jobPropertie.getExecutorRouteStrategy());
                xxlJobInfo.setExecutorHandler(jobPropertie.getExecutorHandler());
                xxlJobInfo.setExecutorParam(JacksonUtil.getInstance().toJson(executeParam));
                xxlJobInfo.setExecutorBlockStrategy(jobPropertie.getExecutorBlockStrategy());
                xxlJobInfo.setExecutorTimeout(jobPropertie.getExecutorTimeout());
                xxlJobInfo.setExecutorFailRetryCount(jobPropertie.getExecutorFailRetryCount());
                xxlJobInfo.setGlueType(jobPropertie.getGlueType());
                xxlJobInfo.setTriggerStatus(1);
                log.info("modifyJob ============= ");
                result = modifyJob(xxlJobInfo);
            }

            if (!result) {
                log.error("初始化initDelayJob失败:{}", jobPropertie.getDelayjob().getJobDesc());
                throw new IllegalStateException("初始化initDelayJob失败");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XxlJobGroup getGroup(String group) throws IOException {
//        String url = "/api/queryGroup";
//        url = url + "/" + group;
//        String rep = HttpUtil.doGet(jobPropertie.getServerUrl() + url, null, true, headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        if (result.getContent() == null) {
//            return null;
//        }
//        return JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(result.getContent()), XxlJobGroup.class);
        return null;
    }


    public XxlJobInfo getJob(int groupId, String jobDesc) throws IOException {
//        String url = "/api/findByGroupAndJobDesc/";
//        url = url + groupId + "/" + jobDesc;
//        String rep = HttpUtil.doGet(jobPropertie.getServerUrl() + url, null, true, headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        if (result.getContent() == null) {
//            return null;
//        }
//        return JacksonUtil.getInstance().fromJson(JacksonUtil.getInstance().toJson(result.getContent()), XxlJobInfo.class);
        return null;
    }

    public boolean addJob(XxlJobInfo jobInfo) throws IOException {
//        String url = "/api/addJob/";
//        String rep = HttpUtil.doPostJson(jobPropertie.getServerUrl() + url, JacksonUtil.getInstance().toJson(jobInfo), headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        return result.getCode() == XXLJobResult.SUCCESS_CODE;
        return false;
    }

    private boolean modifyJob(XxlJobInfo jobInfo) throws IOException {
//        String url = "/api/modifyJob/";
//        String rep = HttpUtil.doPostJson(jobPropertie.getServerUrl() + url, JacksonUtil.getInstance().toJson(jobInfo), headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        return result.getCode() == XXLJobResult.SUCCESS_CODE;
        return false;
    }

    private boolean stopJob(int id) throws IOException {
//        String url = "/api/stop/" + id;
//        String rep = HttpUtil.doPostJson(jobPropertie.getServerUrl() + url, null, headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        return result.getCode() == XXLJobResult.SUCCESS_CODE;
        return false;
    }

    public boolean startJob(int id) throws IOException {
//        String url = "/api/start/" + id;
//        String rep = HttpUtil.doPostJson(jobPropertie.getServerUrl() + url, null, headers);
//        XXLJobResult result = JacksonUtil.getInstance().fromJson(rep, XXLJobResult.class);
//        return result.getCode() == XXLJobResult.SUCCESS_CODE;
        return false;
    }

    public boolean saveOrUpdateJob(String eventId, EventNodeConfigTimedDTO dto) throws Exception {
        XxlJobInfo xxlJobInfo = getJob(xxlJobGroup.getId(), eventId);

        if (xxlJobInfo == null) {
            xxlJobInfo = new XxlJobInfo();
            xxlJobInfo.setAddTime(new Date());
        }

        HttpExecuteParam executeParam = new HttpExecuteParam();
        executeParam.setUrl(jobPropertie.getExecutorParamUrl() + eventId);
        executeParam.setMethod(jobPropertie.getExecutorParamMthod());

        xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        xxlJobInfo.setJobCron(dto.getCron());
        xxlJobInfo.setJobDesc(eventId);

        xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        xxlJobInfo.setAddTime(new Date());
        xxlJobInfo.setUpdateTime(new Date());
        xxlJobInfo.setAuthor(jobPropertie.getAuth());
        xxlJobInfo.setAlarmEmail(jobPropertie.getAlarmEmail());
        xxlJobInfo.setExecutorRouteStrategy(jobPropertie.getExecutorRouteStrategy());
        xxlJobInfo.setExecutorHandler(jobPropertie.getExecutorHandler());
        xxlJobInfo.setExecutorParam(JacksonUtil.getInstance().toJson(executeParam));
        xxlJobInfo.setExecutorBlockStrategy(jobPropertie.getExecutorBlockStrategy());
        xxlJobInfo.setExecutorTimeout(jobPropertie.getExecutorTimeout());
        xxlJobInfo.setExecutorFailRetryCount(jobPropertie.getExecutorFailRetryCount());
        xxlJobInfo.setGlueType(jobPropertie.getGlueType());
        xxlJobInfo.setTriggerStatus(0);
        log.info("modifyJob ============= ");
        if (xxlJobInfo.getId() > 0) {
            modifyJob(xxlJobInfo);
        } else {
            addJob(xxlJobInfo);
        }
        return true;
    }

    public boolean startEventJob(String eventId) throws Exception {
        XxlJobInfo xxlJobInfo = getJob(xxlJobGroup.getId(), eventId);

        if (xxlJobInfo == null) {
            log.error("根据eventId {} 未找到定时job ,启动失败");
            return true;
        }
        log.info("eventId{} start job:{} ============= ", eventId, xxlJobInfo.getId());
        this.startJob(xxlJobInfo.getId());
        return true;
    }

    public boolean stopEventJob(String eventId) throws Exception {
        XxlJobInfo xxlJobInfo = getJob(xxlJobGroup.getId(), eventId);

        if (xxlJobInfo == null) {
            log.error("根据eventId {} 未找到定时job ,无需停止");
            return true;
        }
        xxlJobInfo.setTriggerStatus(0);
        log.info("eventId{} stop job:{} ============= ", eventId, xxlJobInfo.getId());
        stopJob(xxlJobInfo.getId());
        return true;
    }

}
