/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.enums;

import com.xforceplus.landedestate.basecommon.model.DesEnumModel;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import org.apache.commons.beanutils.PropertyUtils;

public class EnumHelp {
    public static <T> LinkedHashMap<String, String> getZEnumDesList(Class<T> enumType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return EnumHelp.getZEnumDesList(enumType, "code", "msg");
    }

    public static <T> LinkedHashMap<String, DesEnumModel> getZDesEnumDesList(Class<T> enumType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return EnumHelp.getZDesEnumDesList(enumType, "code", "msg", "description", "enumType");
    }

    public static <T> LinkedHashMap<String, String> getZEnumDesList(Class<T> enumType, String keyName, String msgName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!enumType.isEnum()) {
            throw new InvalidParameterException();
        }
        T[] enumConstants = enumType.getEnumConstants();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (T ec : enumConstants) {
            Object key = PropertyUtils.getProperty(ec, (String)keyName);
            Object value = PropertyUtils.getProperty(ec, (String)msgName);
            if (key == null) continue;
            map.put(key.toString(), value.toString());
        }
        return map;
    }

    public static <T> LinkedHashMap<String, DesEnumModel> getZDesEnumDesList(Class<T> enumType, String keyName, String msgName, String descriptionName, String typeName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!enumType.isEnum()) {
            throw new InvalidParameterException();
        }
        T[] enumConstants = enumType.getEnumConstants();
        LinkedHashMap<String, DesEnumModel> map = new LinkedHashMap<String, DesEnumModel>();
        for (T ec : enumConstants) {
            Object key = PropertyUtils.getProperty(ec, (String)keyName);
            if (key == null) continue;
            DesEnumModel tmp = new DesEnumModel();
            tmp.setCode(key.toString());
            tmp.setMsg(PropertyUtils.getProperty(ec, (String)msgName));
            tmp.setDescription(PropertyUtils.getProperty(ec, (String)descriptionName));
            tmp.setEnumType(PropertyUtils.getProperty(ec, (String)typeName));
            map.put(key.toString(), tmp);
        }
        return map;
    }
}

