/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;

public class JsonHelp {
    private static final String EMPTY_STRING = "";
    private static final PropertyFilter SCHEMA_FILTER = new PropertyFilter(){

        public boolean apply(Object object, String name, Object value) {
            return !name.equals("schema") || value == null || !JsonHelp.isSubClassOfSchema(value.getClass());
        }
    };

    public static <T> String toString(T obj) {
        String result = EMPTY_STRING;
        if (obj == null) {
            return result;
        }
        result = JSON.toJSONString(obj, (SerializeFilter)SCHEMA_FILTER, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseISO8601DateFormat});
        return result;
    }

    public static <T> T toObj(String json, Class<T> clazz) {
        if (StringHelp.safeIsEmpty(json)) {
            throw new IllegalArgumentException("json");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz");
        }
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <Q, T> T copy(Q t, Class<T> clazz) {
        JSONObject json = (JSONObject)JSONObject.toJSON(t);
        return (T)JSONObject.toJavaObject((JSON)json, clazz);
    }

    private static boolean isSubClassOfSchema(Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            if (!c.getName().equals("com.ctriposs.baiji.schema.Schema")) continue;
            return true;
        }
        return false;
    }
}

