/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.check;

import com.xforceplus.landedestate.basecommon.enums.BaseRequsetCheckEnum;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public class CheckRequestHelp {
    private CheckRequestHelp() {
    }

    public static List<String> checkReqInfoIsNull(Map<String, String> reqInfo) {
        ArrayList<String> errMaps = new ArrayList<String>();
        for (Map.Entry<String, String> info : reqInfo.entrySet()) {
            if (!StringUtils.isBlank((String)info.getValue())) continue;
            errMaps.add(BaseRequsetCheckEnum.getMsg(info.getKey()));
            return errMaps;
        }
        return errMaps;
    }

    public static <T> List<String> checkReqInfoIsNull(Map<String, String> reqInfo, Class<T> enumType) {
        if (!enumType.isEnum()) {
            throw new InvalidParameterException();
        }
        ArrayList<String> errMaps = new ArrayList<String>();
        try {
            T[] enumConstants = enumType.getEnumConstants();
            for (Map.Entry<String, String> info : reqInfo.entrySet()) {
                String key = info.getKey();
                if (!StringHelp.safeIsEmpty(info.getValue())) continue;
                for (T ec : enumConstants) {
                    Object keyEnum = PropertyUtils.getProperty(ec, (String)"code");
                    if (keyEnum == null || !StringHelp.ignoreCaseEquals(key, keyEnum.toString())) continue;
                    errMaps.add(PropertyUtils.getProperty(ec, (String)"msg").toString());
                }
                return errMaps;
            }
        }
        catch (Exception ex) {
            errMaps.add("checkReqInfoIsNull\u7cfb\u7edf\u5f02\u5e38");
        }
        return errMaps;
    }
}

