/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ListHelp {
    public static <T> boolean safeAny(List<T> list) {
        return list != null && list.size() > 0;
    }

    public static <T> T first(List<T> list) {
        if (!ListHelp.safeAny(list)) {
            throw new IllegalArgumentException("list");
        }
        return list.get(0);
    }

    public static <T> T firstOrDefault(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        if (!ListHelp.safeAny(list)) {
            throw new IllegalArgumentException("list");
        }
        return list.get(list.size() - 1);
    }

    public static <T> T lastOrDefault(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> List<T> skip(List<T> list, int count) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = count; i < list.size(); ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> List<T> take(List<T> list, int count) {
        if (list == null) {
            throw new IllegalArgumentException("list");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        ArrayList<T> result = new ArrayList<T>();
        if (count == 0) {
            return result;
        }
        for (T item : list) {
            result.add(item);
            if (result.size() != count) continue;
            break;
        }
        return result;
    }

    public static <T> List<T> removeNull(List<T> list) {
        Vector<Object> nuCon = new Vector<Object>();
        nuCon.add(null);
        list.removeAll(nuCon);
        return list;
    }
}

