/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.other;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IDCardValidateHelp {
    private static String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean isValidatedAllIdcard(String idcard) {
        if (StringHelp.safeIsEmpty(idcard)) {
            return false;
        }
        if (idcard.length() == 15) {
            return IDCardValidateHelp.validate15IDCard(idcard);
        }
        return IDCardValidateHelp.validate18Idcard(idcard);
    }

    private static boolean validate18Idcard(String idcard) {
        if (idcard == null) {
            return false;
        }
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        if (!IDCardValidateHelp.isDigital(idcard17)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (!IDCardValidateHelp.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = idcard.substring(6, 14);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        String idcard18Code = idcard.substring(17, 18);
        char[] c = idcard17.toCharArray();
        int[] bit = IDCardValidateHelp.converCharToInt(c);
        int sum17 = 0;
        sum17 = IDCardValidateHelp.getPowerSum(bit);
        String checkCode = IDCardValidateHelp.getCheckCodeBySum(sum17);
        if (null == checkCode) {
            return false;
        }
        return idcard18Code.equalsIgnoreCase(checkCode);
    }

    private static boolean validate15IDCard(String idcard) {
        if (idcard == null) {
            return false;
        }
        if (idcard.length() != 15) {
            return false;
        }
        if (!IDCardValidateHelp.isDigital(idcard)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (!IDCardValidateHelp.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = idcard.substring(6, 12);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        return true;
    }

    private static boolean checkProvinceid(String provinceid) {
        for (String id : cityCode) {
            if (!id.equals(provinceid)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDigital(String str) {
        return str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    private static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }
}

