/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.other;

public class UAgentInfoHelper {
    private String userAgent = "";
    private String httpAccept = "";
    public boolean initCompleted = false;
    public boolean isWebkit = false;
    public boolean isMobilePhone = false;
    public boolean isIphone = false;
    public boolean isAndroid = false;
    public boolean isAndroidPhone = false;
    public boolean isTierTablet = false;
    public boolean isTierIphone = false;
    public boolean isTierRichCss = false;
    public boolean isTierGenericMobile = false;
    public static final String engineWebKit = "webkit";
    public static final String deviceIphone = "iphone";
    public static final String deviceIpod = "ipod";
    public static final String deviceIpad = "ipad";
    public static final String deviceMacPpc = "macintosh";
    public static final String deviceAndroid = "android";
    public static final String deviceGoogleTV = "googletv";
    public static final String deviceHtcFlyer = "htc_flyer";
    public static final String deviceWinPhone7 = "windows phone os 7";
    public static final String deviceWinPhone8 = "windows phone 8";
    public static final String deviceWinMob = "windows ce";
    public static final String deviceWindows = "windows";
    public static final String deviceIeMob = "iemobile";
    public static final String devicePpc = "ppc";
    public static final String enginePie = "wm5 pie";
    public static final String deviceBB = "blackberry";
    public static final String deviceBB10 = "bb10";
    public static final String vndRIM = "vnd.rim";
    public static final String deviceBBStorm = "blackberry95";
    public static final String deviceBBBold = "blackberry97";
    public static final String deviceBBBoldTouch = "blackberry 99";
    public static final String deviceBBTour = "blackberry96";
    public static final String deviceBBCurve = "blackberry89";
    public static final String deviceBBCurveTouch = "blackberry 938";
    public static final String deviceBBTorch = "blackberry 98";
    public static final String deviceBBPlaybook = "playbook";
    public static final String deviceSymbian = "symbian";
    public static final String deviceS60 = "series60";
    public static final String deviceS70 = "series70";
    public static final String deviceS80 = "series80";
    public static final String deviceS90 = "series90";
    public static final String devicePalm = "palm";
    public static final String deviceWebOS = "webos";
    public static final String deviceWebOShp = "hpwos";
    public static final String engineBlazer = "blazer";
    public static final String engineXiino = "xiino";
    public static final String deviceNuvifone = "nuvifone";
    public static final String deviceBada = "bada";
    public static final String deviceTizen = "tizen";
    public static final String deviceMeego = "meego";
    public static final String deviceKindle = "kindle";
    public static final String engineSilk = "silk-accelerated";
    public static final String vndwap = "vnd.wap";
    public static final String wml = "wml";
    public static final String deviceTablet = "tablet";
    public static final String deviceBrew = "brew";
    public static final String deviceDanger = "danger";
    public static final String deviceHiptop = "hiptop";
    public static final String devicePlaystation = "playstation";
    public static final String devicePlaystationVita = "vita";
    public static final String deviceNintendoDs = "nitro";
    public static final String deviceNintendo = "nintendo";
    public static final String deviceWii = "wii";
    public static final String deviceXbox = "xbox";
    public static final String deviceArchos = "archos";
    public static final String engineOpera = "opera";
    public static final String engineNetfront = "netfront";
    public static final String engineUpBrowser = "up.browser";
    public static final String engineOpenWeb = "openweb";
    public static final String deviceMidp = "midp";
    public static final String uplink = "up.link";
    public static final String engineTelecaQ = "teleca q";
    public static final String engineObigo = "obigo";
    public static final String devicePda = "pda";
    public static final String mini = "mini";
    public static final String mobile = "mobile";
    public static final String mobi = "mobi";
    public static final String maemo = "maemo";
    public static final String linux = "linux";
    public static final String qtembedded = "qt embedded";
    public static final String mylocom2 = "com2";
    public static final String manuSonyEricsson = "sonyericsson";
    public static final String manuericsson = "ericsson";
    public static final String manuSamsung1 = "sec-sgh";
    public static final String manuSony = "sony";
    public static final String manuHtc = "htc";
    public static final String svcDocomo = "docomo";
    public static final String svcKddi = "kddi";
    public static final String svcVodafone = "vodafone";
    public static final String disUpdate = "update";

    public UAgentInfoHelper(String userAgent, String httpAccept) {
        if (userAgent != null) {
            this.userAgent = userAgent.toLowerCase();
        }
        if (httpAccept != null) {
            this.httpAccept = httpAccept.toLowerCase();
        }
        this.initDeviceScan();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getHttpAccept() {
        return this.httpAccept;
    }

    public boolean getIsIphone() {
        return this.isIphone;
    }

    public boolean getIsTierTablet() {
        return this.isTierTablet;
    }

    public boolean getIsTierIphone() {
        return this.isTierIphone;
    }

    public boolean getIsTierRichCss() {
        return this.isTierRichCss;
    }

    public boolean getIsTierGenericMobile() {
        return this.isTierGenericMobile;
    }

    public void initDeviceScan() {
        this.isWebkit = this.detectWebkit();
        this.isIphone = this.detectIphone();
        this.isAndroid = this.detectAndroid();
        this.isAndroidPhone = this.detectAndroidPhone();
        this.isMobilePhone = this.detectMobileQuick();
        this.isTierTablet = this.detectTierTablet();
        this.isTierIphone = this.detectTierIphone();
        this.isTierRichCss = this.detectTierRichCss();
        this.isTierGenericMobile = this.detectTierOtherPhones();
        this.initCompleted = true;
    }

    public boolean detectIphone() {
        if (this.initCompleted || this.isIphone) {
            return this.isIphone;
        }
        return this.userAgent.indexOf(deviceIphone) != -1 && !this.detectIpad() && !this.detectIpod();
    }

    public boolean detectIpod() {
        return this.userAgent.indexOf(deviceIpod) != -1;
    }

    public boolean detectIpad() {
        return this.userAgent.indexOf(deviceIpad) != -1 && this.detectWebkit();
    }

    public boolean detectIphoneOrIpod() {
        return this.userAgent.indexOf(deviceIphone) != -1 || this.userAgent.indexOf(deviceIpod) != -1;
    }

    public boolean detectIos() {
        return this.detectIphoneOrIpod() || this.detectIpad();
    }

    public boolean detectAndroid() {
        if (this.initCompleted || this.isAndroid) {
            return this.isAndroid;
        }
        if (this.userAgent.indexOf(deviceAndroid) != -1 || this.detectGoogleTV()) {
            return true;
        }
        return this.userAgent.indexOf(deviceHtcFlyer) != -1;
    }

    public boolean detectAndroidPhone() {
        if (this.initCompleted || this.isAndroidPhone) {
            return this.isAndroidPhone;
        }
        if (this.detectAndroid() && this.userAgent.indexOf(mobile) != -1) {
            return true;
        }
        if (this.detectOperaAndroidPhone()) {
            return true;
        }
        return this.userAgent.indexOf(deviceHtcFlyer) != -1;
    }

    public boolean detectAndroidTablet() {
        if (!this.detectAndroid()) {
            return false;
        }
        if (this.detectOperaMobile()) {
            return false;
        }
        if (this.userAgent.indexOf(deviceHtcFlyer) != -1) {
            return false;
        }
        return this.userAgent.indexOf(mobile) <= -1;
    }

    public boolean detectAndroidWebKit() {
        return this.detectAndroid() && this.detectWebkit();
    }

    public boolean detectGoogleTV() {
        return this.userAgent.indexOf(deviceGoogleTV) != -1;
    }

    public boolean detectWebkit() {
        if (this.initCompleted || this.isWebkit) {
            return this.isWebkit;
        }
        return this.userAgent.indexOf(engineWebKit) != -1;
    }

    public boolean detectWindowsPhone() {
        return this.detectWindowsPhone7() || this.detectWindowsPhone8();
    }

    public boolean detectWindowsPhone7() {
        return this.userAgent.indexOf(deviceWinPhone7) != -1;
    }

    public boolean detectWindowsPhone8() {
        return this.userAgent.indexOf(deviceWinPhone8) != -1;
    }

    public boolean detectWindowsMobile() {
        if (this.detectWindowsPhone()) {
            return false;
        }
        if (this.userAgent.indexOf(deviceWinMob) != -1 || this.userAgent.indexOf(deviceWinMob) != -1 || this.userAgent.indexOf(deviceIeMob) != -1 || this.userAgent.indexOf(enginePie) != -1 || this.userAgent.indexOf(manuHtc) != -1 && this.userAgent.indexOf(deviceWindows) != -1 || this.detectWapWml() && this.userAgent.indexOf(deviceWindows) != -1) {
            return true;
        }
        return this.userAgent.indexOf(devicePpc) != -1 && this.userAgent.indexOf(deviceMacPpc) == -1;
    }

    public boolean detectBlackBerry() {
        if (this.userAgent.indexOf(deviceBB) != -1 || this.httpAccept.indexOf(vndRIM) != -1) {
            return true;
        }
        return this.detectBlackBerry10Phone();
    }

    public boolean detectBlackBerry10Phone() {
        return this.userAgent.indexOf(deviceBB10) != -1 && this.userAgent.indexOf(mobile) != -1;
    }

    public boolean detectBlackBerryTablet() {
        return this.userAgent.indexOf(deviceBBPlaybook) != -1;
    }

    public boolean detectBlackBerryWebKit() {
        return this.detectBlackBerry() && this.detectWebkit();
    }

    public boolean detectBlackBerryTouch() {
        return this.detectBlackBerry() && (this.userAgent.indexOf(deviceBBStorm) != -1 || this.userAgent.indexOf(deviceBBTorch) != -1 || this.userAgent.indexOf(deviceBBBoldTouch) != -1 || this.userAgent.indexOf(deviceBBCurveTouch) != -1);
    }

    public boolean detectBlackBerryHigh() {
        if (this.detectBlackBerryWebKit()) {
            return false;
        }
        if (this.detectBlackBerry()) {
            return this.detectBlackBerryTouch() || this.userAgent.indexOf(deviceBBBold) != -1 || this.userAgent.indexOf(deviceBBTour) != -1 || this.userAgent.indexOf(deviceBBCurve) != -1;
        }
        return false;
    }

    public boolean detectBlackBerryLow() {
        if (this.detectBlackBerry()) {
            return !this.detectBlackBerryHigh() && !this.detectBlackBerryWebKit();
        }
        return false;
    }

    public boolean detectS60OssBrowser() {
        return this.detectWebkit() && (this.userAgent.indexOf(deviceSymbian) != -1 || this.userAgent.indexOf(deviceS60) != -1);
    }

    public boolean detectSymbianOS() {
        return this.userAgent.indexOf(deviceSymbian) != -1 || this.userAgent.indexOf(deviceS60) != -1 || this.userAgent.indexOf(deviceS70) != -1 || this.userAgent.indexOf(deviceS80) != -1 || this.userAgent.indexOf(deviceS90) != -1;
    }

    public boolean detectPalmOS() {
        if (this.detectPalmWebOS()) {
            return false;
        }
        return this.userAgent.indexOf(devicePalm) != -1 || this.userAgent.indexOf(engineBlazer) != -1 || this.userAgent.indexOf(engineXiino) != -1;
    }

    public boolean detectPalmWebOS() {
        return this.userAgent.indexOf(deviceWebOS) != -1;
    }

    public boolean detectWebOSTablet() {
        return this.userAgent.indexOf(deviceWebOShp) != -1 && this.userAgent.indexOf(deviceTablet) != -1;
    }

    public boolean detectOperaMobile() {
        return this.userAgent.indexOf(engineOpera) != -1 && (this.userAgent.indexOf(mini) != -1 || this.userAgent.indexOf(mobi) != -1);
    }

    public boolean detectOperaAndroidPhone() {
        return this.userAgent.indexOf(engineOpera) != -1 && this.userAgent.indexOf(deviceAndroid) != -1 && this.userAgent.indexOf(mobi) != -1;
    }

    public boolean detectOperaAndroidTablet() {
        return this.userAgent.indexOf(engineOpera) != -1 && this.userAgent.indexOf(deviceAndroid) != -1 && this.userAgent.indexOf(deviceTablet) != -1;
    }

    public boolean detectKindle() {
        return this.userAgent.indexOf(deviceKindle) != -1 && !this.detectAndroid();
    }

    public boolean detectAmazonSilk() {
        return this.userAgent.indexOf(engineSilk) != -1;
    }

    public boolean detectGarminNuvifone() {
        return this.userAgent.indexOf(deviceNuvifone) != -1;
    }

    public boolean detectBada() {
        return this.userAgent.indexOf(deviceBada) != -1;
    }

    public boolean detectTizen() {
        return this.userAgent.indexOf(deviceTizen) != -1;
    }

    public boolean detectMeego() {
        return this.userAgent.indexOf(deviceMeego) != -1;
    }

    public boolean detectDangerHiptop() {
        return this.userAgent.indexOf(deviceDanger) != -1 || this.userAgent.indexOf(deviceHiptop) != -1;
    }

    public boolean detectSonyMylo() {
        return this.userAgent.indexOf(manuSony) != -1 && (this.userAgent.indexOf(qtembedded) != -1 || this.userAgent.indexOf(mylocom2) != -1);
    }

    public boolean detectMaemoTablet() {
        if (this.userAgent.indexOf(maemo) != -1) {
            return true;
        }
        return this.userAgent.indexOf(linux) != -1 && this.userAgent.indexOf(deviceTablet) != -1 && !this.detectWebOSTablet() && !this.detectAndroid();
    }

    public boolean detectArchos() {
        return this.userAgent.indexOf(deviceArchos) != -1;
    }

    public boolean detectGameConsole() {
        return this.detectSonyPlaystation() || this.detectNintendo() || this.detectXbox();
    }

    public boolean detectSonyPlaystation() {
        return this.userAgent.indexOf(devicePlaystation) != -1;
    }

    public boolean detectGamingHandheld() {
        return this.userAgent.indexOf(devicePlaystation) != -1 && this.userAgent.indexOf(devicePlaystationVita) != -1;
    }

    public boolean detectNintendo() {
        return this.userAgent.indexOf(deviceNintendo) != -1 || this.userAgent.indexOf(deviceWii) != -1 || this.userAgent.indexOf(deviceNintendoDs) != -1;
    }

    public boolean detectXbox() {
        return this.userAgent.indexOf(deviceXbox) != -1;
    }

    public boolean detectBrewDevice() {
        return this.userAgent.indexOf(deviceBrew) != -1;
    }

    public boolean detectWapWml() {
        return this.httpAccept.indexOf(vndwap) != -1 || this.httpAccept.indexOf(wml) != -1;
    }

    public boolean detectMidpCapable() {
        return this.userAgent.indexOf(deviceMidp) != -1 || this.httpAccept.indexOf(deviceMidp) != -1;
    }

    public boolean detectSmartphone() {
        return this.detectTierIphone() || this.detectS60OssBrowser() || this.detectSymbianOS() || this.detectWindowsMobile() || this.detectBlackBerry() || this.detectPalmOS();
    }

    public boolean detectMobileQuick() {
        if (this.initCompleted || this.isMobilePhone) {
            return this.isMobilePhone;
        }
        if (this.detectSmartphone()) {
            return true;
        }
        if (this.detectWapWml() || this.detectBrewDevice() || this.detectOperaMobile() || this.detectTierTablet()) {
            return true;
        }
        if (this.userAgent.indexOf(engineObigo) != -1 || this.userAgent.indexOf(engineNetfront) != -1 || this.userAgent.indexOf(engineUpBrowser) != -1 || this.userAgent.indexOf(engineOpenWeb) != -1) {
            return true;
        }
        if (this.detectDangerHiptop() || this.detectMidpCapable() || this.detectMaemoTablet() || this.detectArchos()) {
            return true;
        }
        if (this.userAgent.indexOf(devicePda) != -1 && this.userAgent.indexOf(disUpdate) < 0) {
            return true;
        }
        if (this.userAgent.indexOf(mobile) != -1) {
            return true;
        }
        return this.detectKindle() || this.detectAmazonSilk();
    }

    public boolean detectMobileLong() {
        if (this.detectMobileQuick() || this.detectGameConsole() || this.detectSonyMylo()) {
            return true;
        }
        if (this.userAgent.indexOf(uplink) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuSonyEricsson) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuericsson) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuSamsung1) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(svcDocomo) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(svcKddi) != -1) {
            return true;
        }
        return this.userAgent.indexOf(svcVodafone) != -1;
    }

    public boolean detectTierTablet() {
        if (this.initCompleted || this.isTierTablet) {
            return this.isTierTablet;
        }
        return this.detectIpad() || this.detectAndroidTablet() || this.detectBlackBerryTablet() || this.detectWebOSTablet();
    }

    public boolean detectTierIphone() {
        if (this.initCompleted || this.isTierIphone) {
            return this.isTierIphone;
        }
        return this.detectIphoneOrIpod() || this.detectAndroidPhone() || this.detectWindowsPhone() || this.detectBlackBerry10Phone() || this.detectBlackBerryWebKit() && this.detectBlackBerryTouch() || this.detectPalmWebOS() || this.detectBada() || this.detectTizen() || this.detectGamingHandheld();
    }

    public boolean detectTierRichCss() {
        if (this.initCompleted || this.isTierRichCss) {
            return this.isTierRichCss;
        }
        boolean result = false;
        if (this.detectMobileQuick() && !this.detectTierIphone() && !this.detectKindle() && (this.detectWebkit() || this.detectS60OssBrowser() || this.detectBlackBerryHigh() || this.detectWindowsMobile() || this.userAgent.indexOf(engineTelecaQ) != -1)) {
            result = true;
        }
        return result;
    }

    public boolean detectTierOtherPhones() {
        if (this.initCompleted || this.isTierGenericMobile) {
            return this.isTierGenericMobile;
        }
        return this.detectMobileLong() && !this.detectTierIphone() && !this.detectTierRichCss();
    }
}

