/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.vaildate;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public class ValidatorUtil {
    public static boolean isEmpty(String value) {
        return StringHelp.safeIsEmpty(value);
    }

    public static boolean isNotEmpty(String value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean isEmpty(Collection<?> value) {
        return value == null || value.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean isEmpty(Object value) {
        return value == null;
    }

    public static boolean isNotEmpty(Object value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean inLength(String value, int ... lengths) {
        return Arrays.stream(lengths).anyMatch(length -> value.length() == length);
    }

    public static boolean inLengthRange(String value, int minLength, int maxLength) {
        int length = value.length();
        return length >= minLength && length <= maxLength;
    }

    public static boolean inRange(Integer value, int minValue, int maxValue, String type) {
        switch (type) {
            case "()": {
                return value > minValue && value < maxValue;
            }
            case "(]": {
                return value > minValue && value <= maxValue;
            }
            case "[)": {
                return value >= minValue && value < maxValue;
            }
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean isInteger(String value) {
        String regex = "0|([1-9][0-9]{0,10})";
        return Pattern.matches(regex, value);
    }

    public static boolean isNumber(String value) {
        String regex = "[0-9]+";
        return Pattern.matches(regex, value);
    }

    public static boolean noSymbols(String value) {
        String regex = "[0-9a-zA-Z]+";
        return Pattern.matches(regex, value);
    }

    public static boolean noSymbolsAndLower(String value) {
        String regex = "[0-9A-Z]+";
        return Pattern.matches(regex, value);
    }

    public static boolean isDate(String value, String format) {
        try {
            new SimpleDateFormat(format).parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

