/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.excel;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.landedestate.basecommon.help.lang.DateHelp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EasyExcelHelp {
    private static Logger logger = LoggerFactory.getLogger(EasyExcelHelp.class);

    public static OutputStream export(List<? extends BaseRowModel> data, String fileName, String sheetName, Class<? extends BaseRowModel> clazz) throws FileNotFoundException {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        String folder = System.getProperty("user.dir") + "/" + fileName + DateHelp.getTimeChinaString(new Date()) + ".xls";
        File file = new File(folder);
        FileOutputStream outputStream = new FileOutputStream(file);
        ExcelWriter excelWriter = new ExcelWriter((OutputStream)outputStream, ExcelTypeEnum.XLS);
        int sheetNo = 1;
        try {
            Sheet sheet = new Sheet(sheetNo, 0, clazz);
            sheet.setSheetName(sheetName);
            sheet.setAutoWidth(Boolean.TRUE);
            excelWriter.write(data, sheet);
            excelWriter.finish();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStream;
    }
}

