/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class TableInfoAnnotationPlugin
extends PluginAdapter {
    public static final List<String> noCompareFields = Arrays.asList("createUserId", "createUserName", "createTime", "updateUserId", "updateUserName", "updateTime");

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            topLevelClass.addImportedType(new FullyQualifiedJavaType("com.xforceplus.landedestate.basecommon.annotation.TableInfo"));
            StringBuilder sb = new StringBuilder("@TableInfo(");
            sb.append("tableName=\"").append(introspectedTable.getFullyQualifiedTableNameAtRuntime()).append("\", keyName=\"").append(StringUtils.join((Collection)introspectedTable.getPrimaryKeyColumns().stream().map(IntrospectedColumn::getActualColumnName).collect(Collectors.toList()), (String)",")).append("\", keyFieldName=\"").append(StringUtils.join((Collection)introspectedTable.getPrimaryKeyColumns().stream().map(IntrospectedColumn::getJavaProperty).collect(Collectors.toList()), (String)",")).append("\")");
            topLevelClass.addAnnotation(sb.toString());
        }
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            topLevelClass.addImportedType(new FullyQualifiedJavaType("com.xforceplus.landedestate.basecommon.annotation.Description"));
            topLevelClass.addImportedType(new FullyQualifiedJavaType("com.xforceplus.landedestate.basecommon.annotation.NoCompare"));
            StringBuilder sb = new StringBuilder("@Description(\"");
            String remarks = introspectedColumn.getRemarks();
            remarks = remarks.replaceAll("[\t\r\n]", "");
            remarks = remarks.replaceAll("\"", "'");
            remarks = remarks.split("[ ,\uff0c\uff1a:\\(\uff08]")[0];
            sb.append(remarks).append("\")");
            field.addAnnotation(sb.toString());
            if (noCompareFields.contains(introspectedColumn.getJavaProperty())) {
                field.addAnnotation("@NoCompare");
            }
        }
        return true;
    }
}

