/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.soa;

import com.xforceplus.landedestate.basecommon.exception.NoDataException;
import com.xforceplus.landedestate.basecommon.help.JsonHelp;
import com.xforceplus.landedestate.basecommon.help.ReflectProperty;
import com.xforceplus.landedestate.basecommon.help.entity.ModelCopier;
import com.xforceplus.landedestate.basecommon.help.lang.DateTimeHelp;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.logger.LogTagHelp;
import com.xforceplus.landedestate.basecommon.logger.LoggerHelp;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoaExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"SoaExecutor");

    public static <S, R, Q> Q execute(S client, String name, R request, boolean checkResult) {
        Q response = SoaExecutor.execute(client, name, request);
        try {
            if (checkResult) {
                String resCode = "";
                String resMsg = "";
                Object resData = new Object();
                Class<?> resClass = response.getClass();
                Field[] declaredFields = new Field[]{};
                block13: for (Field field : declaredFields = ModelCopier.getBeanFields(resClass, declaredFields)) {
                    String fieldName = field.getName().toLowerCase();
                    Field idF = ReflectProperty.getProperty(resClass, fieldName);
                    if (null == idF) continue;
                    idF.setAccessible(true);
                    Object data = idF.get(response);
                    switch (fieldName) {
                        case "code": {
                            resCode = StringHelp.safeToString(data);
                            continue block13;
                        }
                        case "message": {
                            resMsg = StringHelp.safeToString(data);
                            continue block13;
                        }
                        case "result": {
                            resData = data;
                        }
                    }
                }
                if (resCode.equals("0")) {
                    throw new NoDataException(resMsg);
                }
                if (null == resData) {
                    throw new NoDataException("\u67e5\u8be2\u6570\u636e\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (NoDataException ex) {
            throw new NoDataException(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(name + ":request" + JsonHelp.toString(request) + ",expMsg:" + ex.getMessage());
            throw new RuntimeException(ex);
        }
        return response;
    }

    public static <S, R, Q> Q execute(S client, String name, R request) {
        if (client == null) {
            throw new IllegalArgumentException("client");
        }
        if (StringHelp.safeIsEmpty(name)) {
            throw new IllegalArgumentException("name");
        }
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        Object response = null;
        Date startTime = new Date();
        try {
            HashMap<String, String> logtag = LogTagHelp.getSoaLogTag(request);
            logtag.put("s", name);
            String reqMessage = JsonHelp.toString(request);
            LoggerHelp.writeSoaRequest(name, reqMessage, logtag);
            Method method = client.getClass().getMethod(name, request.getClass());
            response = method.invoke(client, request);
            String resMessage = JsonHelp.toString(response);
            LoggerHelp.writeSoaResponse(name, reqMessage, resMessage, DateTimeHelp.getTimeSpan(startTime), logtag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(name + ":request" + JsonHelp.toString(request) + ",expMsg:" + ex.getMessage());
            throw new RuntimeException(ex);
        }
        return (Q)response;
    }
}

