/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.wsprocess;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.wsprocess.ErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WSAbstractProcesser<TReq, TRep> {
    private static final Logger logger = LoggerFactory.getLogger((String)"WSAbstractProcesser");
    protected TReq Request;
    protected TRep Response;
    protected ErrorInfo error = new ErrorInfo();
    protected boolean doRes = false;

    protected void checkRequest() {
    }

    protected abstract void processing();

    protected abstract void processComplete();

    public TRep process() {
        this.checkRequest();
        this.processing();
        this.processComplete();
        return this.Response;
    }

    protected void doException(Exception ex) {
        if (StringHelp.ignoreCaseEquals("NoDataException", ex.getClass().getSimpleName())) {
            this.error.setErrorCode(1);
        } else {
            logger.error(this.getClass().getSimpleName() + " ex=" + ex.toString());
            this.error.setErrorCode(0);
        }
        this.error.setErrorMessage(ex.getMessage());
    }
}

