/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.annotation;

import com.xforceplus.landedestate.basecommon.help.ReflectProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class AnnotationHelp {
    public static <T extends Annotation> T getTypeAnnotation(Class clazz, Class<T> annotationClass) {
        if (clazz == null || annotationClass == null) {
            throw new IllegalArgumentException();
        }
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            return null;
        }
        return annotation;
    }

    public static <T extends Annotation> T getMethodAnnotation(Class clazz, String methodName, Class<T> annotationClass) throws NoSuchMethodException, SecurityException {
        Method[] methods = clazz.getMethods();
        Method method = null;
        int methodCount = 0;
        for (Method mth : methods) {
            if (!mth.getName().equals(methodName)) continue;
            method = mth;
            ++methodCount;
        }
        if (method == null || methodCount > 1) {
            throw new NoSuchMethodException("no such method or count of method name great than 1");
        }
        return AnnotationHelp.getMethodAnnotation(method, annotationClass);
    }

    public static <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annotationClass) {
        if (method == null || annotationClass == null) {
            throw new IllegalArgumentException();
        }
        return method.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getFieldAnnotation(Class clazz, String fieldName, Class<T> annotationClass) {
        Field field = ReflectProperty.getProperty(clazz, fieldName);
        return AnnotationHelp.getFieldAnnotation(field, annotationClass);
    }

    public static <T extends Annotation> T getFieldAnnotation(Field field, Class<T> annotationClass) {
        if (field == null || annotationClass == null) {
            throw new IllegalArgumentException();
        }
        return field.getAnnotation(annotationClass);
    }
}

