/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.check;

import com.xforceplus.landedestate.basecommon.enums.ChcekRegularEnum;
import com.xforceplus.landedestate.basecommon.help.other.IDCardValidateHelp;
import com.xforceplus.landedestate.basecommon.help.other.RegExUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CheckRegularHelp {
    private CheckRegularHelp() {
    }

    public static List<String> checkIsWrong(Map<ChcekRegularEnum, String> reqInfo) {
        ArrayList<String> errMaps = new ArrayList<String>();
        for (Map.Entry<ChcekRegularEnum, String> info : reqInfo.entrySet()) {
            boolean ret = true;
            switch (info.getKey()) {
                case MOBILE: {
                    ret = RegExUtil.checkMobile(info.getValue());
                    break;
                }
                case TEL: {
                    ret = RegExUtil.checkNumCha3(info.getValue()) || RegExUtil.checkMobile(info.getValue());
                    break;
                }
                case EMAIL: {
                    ret = RegExUtil.checkEmail(info.getValue());
                    break;
                }
                case PASSWORD8: {
                    ret = RegExUtil.checkPassword_8(info.getValue());
                    break;
                }
                case PASSWORD6: {
                    ret = RegExUtil.checkPassword_6(info.getValue());
                    break;
                }
                case IDCARD: {
                    ret = IDCardValidateHelp.isValidatedAllIdcard(info.getValue());
                    break;
                }
                case TAXNUM: {
                    boolean bl = ret = RegExUtil.checkTaxNum(info.getValue());
                }
            }
            if (ret) continue;
            errMaps.add(ChcekRegularEnum.getMsg(info.getKey().toString()));
            return errMaps;
        }
        return errMaps;
    }
}

