/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.excel;

import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.landedestate.basecommon.help.excel.ExcelListener;
import com.xforceplus.xplatsecurity.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class EasyExcelHelp {
    private static Logger logger = LoggerFactory.getLogger(EasyExcelHelp.class);

    public static ByteArrayOutputStream export(List<? extends BaseRowModel> data, String sheetName, Class<? extends BaseRowModel> clazz) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!CollectionUtils.isEmpty(data) || null != clazz) {
            ExcelWriter excelWriter = new ExcelWriter((OutputStream)outputStream, ExcelTypeEnum.XLSX);
            int sheetNo = 1;
            try {
                Sheet sheet = new Sheet(sheetNo, 0, clazz);
                sheet.setSheetName(sheetName);
                sheet.setAutoWidth(Boolean.TRUE);
                excelWriter.write(data, sheet);
                excelWriter.finish();
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{},{}", (Object)ex.getMessage(), (Object)JsonUtils.writeObjectToJson(data));
            }
        }
        return outputStream;
    }

    public static ByteArrayOutputStream exportTwoSheet(List<? extends BaseRowModel> data, String sheetName, Class<? extends BaseRowModel> clazz, List<? extends BaseRowModel> data2, String sheetName2, Class<? extends BaseRowModel> clazz2) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!CollectionUtils.isEmpty(data) || null != clazz) {
            ExcelWriter excelWriter = new ExcelWriter((OutputStream)outputStream, ExcelTypeEnum.XLSX);
            int sheetNo = 1;
            try {
                Sheet sheet = new Sheet(sheetNo, 0, clazz);
                sheet.setSheetName(sheetName);
                sheet.setAutoWidth(Boolean.TRUE);
                Sheet sheet2 = new Sheet(++sheetNo, 0, clazz2);
                sheet2.setSheetName(sheetName2);
                sheet2.setAutoWidth(Boolean.TRUE);
                excelWriter.write(data, sheet);
                excelWriter.write(data2, sheet2);
                excelWriter.finish();
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{},{}", (Object)ex.getMessage(), (Object)JsonUtils.writeObjectToJson(data));
            }
        }
        return outputStream;
    }

    public static <T extends BaseRowModel> List<T> readExcel(InputStream inputStream, Class<? extends BaseRowModel> clazz) {
        if (null == inputStream) {
            throw new NullPointerException("the inputStream is null!");
        }
        ExcelListener listener = new ExcelListener();
        ExcelReader reader = new ExcelReader(inputStream, EasyExcelHelp.valueOf(inputStream), null, listener);
        reader.read(new Sheet(1, 1, clazz));
        return listener.getRows();
    }

    public static ExcelTypeEnum valueOf(InputStream inputStream) {
        try {
            FileMagic fileMagic = FileMagic.valueOf((InputStream)inputStream);
            if (FileMagic.OLE2.equals((Object)fileMagic)) {
                return ExcelTypeEnum.XLS;
            }
            if (FileMagic.OOXML.equals((Object)fileMagic)) {
                return ExcelTypeEnum.XLSX;
            }
            throw new IllegalArgumentException("excelTypeEnum can not null");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

