/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.lang;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public final class DateConvert {
    private static String dateFormat = "yyyy-MM-dd";

    public static Calendar convertStringToCalendar(String dateString) {
        return DateConvert.convertStringToCalendar(dateString, dateFormat);
    }

    public static Calendar convertStringToCalendar(String dateString, String dateFormat) {
        if (StringUtils.isEmpty((String)dateString)) {
            return null;
        }
        return DateConvert.convertDateToCalendar(DateConvert.convertStringToDate(dateString, dateFormat));
    }

    public static Date convertStringToDate(String dateString) {
        return DateConvert.convertStringToDate(dateString, dateFormat);
    }

    public static Date convertStringToDate(String dateString, String dateFormat) {
        if (StringUtils.isEmpty((String)dateString)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Calendar convertDateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static Calendar getNowCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar addYear(Integer years) {
        Calendar calendar = Calendar.getInstance();
        return DateConvert.addYear(calendar, years);
    }

    public static Calendar addYear(Calendar calendar, Integer years) {
        calendar.add(1, years);
        return calendar;
    }

    public static String convertCalendarToString(Calendar calendar) {
        Date source = calendar.getTime();
        return DateConvert.convertDateToString(source, dateFormat);
    }

    public static String convertCalendarToString(Calendar calendar, String dateFormat) {
        Date date = calendar.getTime();
        return DateConvert.convertDateToString(date, dateFormat);
    }

    public static String convertDateToString(Date date) {
        return DateConvert.convertDateToString(date, dateFormat);
    }

    public static String convertDateToString(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String dateString = "";
        try {
            dateString = sdf.format(date);
        }
        catch (Exception e) {
            return null;
        }
        return dateString;
    }

    public static Calendar getCalendarEndTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static long getDayDiff(Calendar beginCalendar, Calendar endCalendar) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            String beginStr = DateConvert.convertCalendarToString(beginCalendar, dateFormat);
            String endStr = DateConvert.convertCalendarToString(endCalendar, dateFormat);
            Date beginDate = format.parse(beginStr);
            Date endDate = format.parse(endStr);
            return (endDate.getTime() - beginDate.getTime()) / 86400000L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_day(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            return day;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_hour(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            return hour;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_min(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            return min;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_sec(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
            return s;
        }
        catch (Exception ex) {
            return 0L;
        }
    }
}

