/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.lang;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeHelp {
    public static long getTimespanInMilliseconds(Date end, Date start) {
        if (start == null) {
            throw new IllegalArgumentException("start");
        }
        if (end == null) {
            throw new IllegalArgumentException("end");
        }
        return end.getTime() - start.getTime();
    }

    public static Calendar toCalendar(Object date) {
        Calendar result = Calendar.getInstance();
        try {
            switch (date.getClass().toString().toLowerCase()) {
                case "class java.util.date": 
                case "date": {
                    result = DateTimeHelp.toCalendar((Date)date);
                    break;
                }
                case "class java.sql.timestamp": 
                case "timestamp": {
                    result = DateTimeHelp.toCalendar((Timestamp)date);
                    break;
                }
                case "class java.lang.string": 
                case "string": {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date res = sdf.parse(StringHelp.safeToString(date));
                    result = DateTimeHelp.toCalendar(res);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Calendar toCalendar(Date date) {
        Calendar result = Calendar.getInstance();
        result.setTime(date);
        return result;
    }

    public static Calendar toCalendar(Timestamp ts) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts.getTime());
        return result;
    }

    public static Calendar toCalendar(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date res = sdf.parse(date);
        return DateTimeHelp.toCalendar(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Timestamp ts, String pattern) {
        String result = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            result = format.format(ts);
            return result;
        }
        catch (Exception exception) {}
        finally {
            return result;
        }
    }

    public static Timestamp toTimestamp(Object date) {
        Timestamp result = new Timestamp(System.currentTimeMillis());
        try {
            switch (date.getClass().toString().toLowerCase()) {
                case "class java.util.date": {
                    result = DateTimeHelp.toTimestamp((Date)date);
                    break;
                }
                case "class java.util.calendar": 
                case "calendar": {
                    result = DateTimeHelp.toTimestamp((Calendar)date);
                    break;
                }
                case "class java.lang.string": 
                case "string": {
                    result = DateTimeHelp.toTimestamp(StringHelp.safeToString(date));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Timestamp toTimestamp(String date) {
        return Timestamp.valueOf(date);
    }

    public static Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(Calendar calendar) {
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date toDate(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static Calendar getNowCalendar() {
        return Calendar.getInstance();
    }

    public static Timestamp getNowTimestamp() {
        return DateTimeHelp.toTimestamp(DateTimeHelp.getNowDate());
    }

    public static Date getDatePart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getToday() {
        return DateTimeHelp.getDatePart(DateTimeHelp.getNowDate());
    }

    public static Date addYears(Date date, int years) {
        return DateTimeHelp.add(date, 1, years);
    }

    public static Date addMonths(Date date, int months) {
        return DateTimeHelp.add(date, 2, months);
    }

    public static Date addDays(Date date, int days) {
        return DateTimeHelp.add(date, 5, days);
    }

    public static Date addHours(Date date, int hours) {
        return DateTimeHelp.add(date, 10, hours);
    }

    public static Date addMinutes(Date date, int minutes) {
        return DateTimeHelp.add(date, 12, minutes);
    }

    public static Date addSeconds(Date date, int seconds) {
        return DateTimeHelp.add(date, 13, seconds);
    }

    private static Date add(Date date, int field, int amount) {
        Calendar calendar = DateTimeHelp.toCalendar(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static long getTimeSpan(Date startDate) {
        return new Date().getTime() - startDate.getTime();
    }

    public static Calendar getCalenderByString(String val, SimpleDateFormat sdf) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = sdf.parse(val);
            calendar.setTime(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }
}

