/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.help.list;

import com.xforceplus.landedestate.basecommon.annotation.AnnotationHelp;
import com.xforceplus.landedestate.basecommon.annotation.ModelMapped;
import com.xforceplus.landedestate.basecommon.help.ReflectProperty;
import com.xforceplus.landedestate.basecommon.help.entity.ModelCopier;
import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import com.xforceplus.landedestate.basecommon.help.list.ListHelp;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ListConvertHelp {
    public static <T> String getElement(List<T> list, String propertyName) {
        return ListConvertHelp.getElement(list, propertyName, "\uff0c");
    }

    public static <T> String getElement(List<T> list, String propertyName, String split) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        Field field = ReflectProperty.getProperty(list.get(0).getClass(), propertyName);
        if (field == null) {
            // empty if block
        }
        field.setAccessible(true);
        HashSet<String> set = new HashSet<String>();
        try {
            for (T t : list) {
                set.add(field.get(t).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (set != null && !set.isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (Object e : set) {
                str.append(e.toString());
                str.append(split);
            }
            return str.substring(0, str.length() - 1).toString();
        }
        return "";
    }

    public static <T> List<String> getElementList(List<T> list, String propertyName) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Field field = ReflectProperty.getProperty(list.get(0).getClass(), propertyName);
        field.setAccessible(true);
        if (field == null) {
            // empty if block
        }
        field.setAccessible(true);
        ArrayList<String> objs = new ArrayList<String>();
        try {
            for (T t : list) {
                String target = field.get(t).toString();
                if (objs.contains(target)) continue;
                objs.add(target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objs;
    }

    public static <T> List<T> getResList(List<T> doList, String fieldName, String data) {
        if (!ListHelp.safeAny(doList)) {
            return null;
        }
        List resList = doList.stream().filter(e -> {
            try {
                return ReflectProperty.getProperty(doList.get(0).getClass(), fieldName).get(e).equals(data);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return false;
            }
        }).collect(Collectors.toList());
        return resList;
    }

    public static <T> T getFirstDataFromList(List<T> doList, String fieldName, String data) {
        if (!ListHelp.safeAny(doList)) {
            return null;
        }
        T resEntity = doList.stream().filter(e -> {
            try {
                return StringHelp.ignoreCaseEquals(data, ReflectProperty.getProperty(doList.get(0).getClass(), fieldName).get(e).toString());
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return false;
            }
        }).findFirst().orElse(null);
        return resEntity;
    }

    public static <M, A, R> List<R> leftJoinList(List<M> mainList, List<A> addList, String joinName, Class<R> resClass) {
        List<Object> resList = new ArrayList();
        if (!ListHelp.safeAny(mainList)) {
            return resList;
        }
        try {
            Class<?> mainClass = mainList.get(0).getClass();
            Field fieldJoin = ReflectProperty.getProperty(mainClass, joinName);
            if (!ListHelp.safeAny(addList) || null == fieldJoin) {
                resList = ModelCopier.CopyList(mainList, resClass);
                return resList;
            }
            fieldJoin.setAccessible(true);
            Class<?> addClass = addList.get(0).getClass();
            for (M source : mainList) {
                Object resData = null;
                AccessibleObject[] declaredFields = resClass.getDeclaredFields();
                AccessibleObject.setAccessible(declaredFields, true);
                String joinData = StringHelp.safeToString(fieldJoin.get(source));
                if (StringHelp.safeIsEmpty(joinData)) {
                    resData = ModelCopier.CopyModel(source, resClass);
                } else {
                    A addEntity = ListConvertHelp.getFirstDataFromList(addList, joinName, joinData);
                    R obj = resClass.newInstance();
                    for (AccessibleObject field : declaredFields) {
                        try {
                            ModelMapped result = AnnotationHelp.getFieldAnnotation(resClass, ((Field)field).getName(), ModelMapped.class);
                            String fieldName = null == result ? ((Field)field).getName() : result.value();
                            Field idF = ReflectProperty.getProperty(mainClass, fieldName);
                            Field idF_A = ReflectProperty.getProperty(addClass, fieldName);
                            if (null == idF && null == idF_A) continue;
                            String data = "";
                            if (null != idF) {
                                idF.setAccessible(true);
                                data = StringHelp.safeToString(idF.get(source));
                            } else if (null != idF_A && null != addEntity) {
                                idF_A.setAccessible(true);
                                data = StringHelp.safeToString(idF_A.get(addEntity));
                            }
                            ModelCopier.fieldSet(obj, (Field)field, data, true);
                        }
                        catch (Exception ex) {
                            ((Field)field).set(obj, null);
                        }
                    }
                    resData = obj;
                }
                resList.add(resData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resList;
    }

    public static <M, A, R> List<R> innerJoin(List<M> mainList, List<A> addList, String joinName, Class<R> resClass) {
        List<Object> resList = new ArrayList();
        if (!ListHelp.safeAny(mainList)) {
            return resList;
        }
        try {
            Class<?> mainClass = mainList.get(0).getClass();
            Class<?> addClass = addList.get(0).getClass();
            Field field_M = ReflectProperty.getProperty(mainClass, joinName);
            Field field_A = ReflectProperty.getProperty(addClass, joinName);
            if (!ListHelp.safeAny(addList) || null == field_M || null == field_A) {
                resList = ModelCopier.CopyList(mainList, resClass);
                return resList;
            }
            field_M.setAccessible(true);
            field_A.setAccessible(true);
            resList = mainList.stream().flatMap(left -> addList.stream().filter(right -> {
                try {
                    return field_M.get(left).equals(field_A.get(right));
                }
                catch (Exception ex) {
                    return false;
                }
            }).filter(ListConvertHelp.distinctByKey(right -> field_A)).map(right -> {
                try {
                    Object resData = null;
                    AccessibleObject[] declaredFields = resClass.getDeclaredFields();
                    AccessibleObject.setAccessible(declaredFields, true);
                    Object obj = resClass.newInstance();
                    for (AccessibleObject field : declaredFields) {
                        try {
                            ModelMapped result = AnnotationHelp.getFieldAnnotation(resClass, ((Field)field).getName(), ModelMapped.class);
                            String fieldName = null == result ? ((Field)field).getName() : result.value();
                            Field idF = ReflectProperty.getProperty(mainClass, fieldName);
                            Field idF_A = ReflectProperty.getProperty(addClass, fieldName);
                            if (null == idF && null == idF_A) continue;
                            String data = "";
                            if (null != idF) {
                                idF.setAccessible(true);
                                data = StringHelp.safeToString(idF.get(left));
                            } else if (null != idF_A) {
                                idF_A.setAccessible(true);
                                data = StringHelp.safeToString(idF_A.get(right));
                            }
                            ModelCopier.fieldSet(obj, (Field)field, data, true);
                        }
                        catch (Exception ex) {
                            ((Field)field).set(obj, null);
                        }
                    }
                    resData = obj;
                    return resData;
                }
                catch (Exception ex) {
                    return null;
                }
            })).collect(Collectors.toList());
            resList = ListHelp.removeNull(resList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resList;
    }

    public static <M, A, R> List<R> innerJoin(List<M> mainList, List<A> addList, String mainJoinName, String addJoinName, Class<R> resClass) {
        List<Object> resList = new ArrayList();
        if (!ListHelp.safeAny(mainList)) {
            return resList;
        }
        try {
            Class<?> mainClass = mainList.get(0).getClass();
            Class<?> addClass = addList.get(0).getClass();
            Field field_M = ReflectProperty.getProperty(mainClass, mainJoinName);
            Field field_A = ReflectProperty.getProperty(addClass, addJoinName);
            if (!ListHelp.safeAny(addList) || null == field_M || null == field_A) {
                resList = ModelCopier.CopyList(mainList, resClass);
                return resList;
            }
            field_M.setAccessible(true);
            field_A.setAccessible(true);
            resList = mainList.stream().flatMap(left -> addList.stream().filter(right -> {
                try {
                    return field_M.get(left).equals(field_A.get(right));
                }
                catch (Exception ex) {
                    return false;
                }
            }).filter(ListConvertHelp.distinctByKey(right -> field_A)).map(right -> {
                try {
                    Object resData = null;
                    AccessibleObject[] declaredFields = resClass.getDeclaredFields();
                    AccessibleObject.setAccessible(declaredFields, true);
                    Object obj = resClass.newInstance();
                    for (AccessibleObject field : declaredFields) {
                        try {
                            ModelMapped result = AnnotationHelp.getFieldAnnotation(resClass, ((Field)field).getName(), ModelMapped.class);
                            String fieldName = null == result ? ((Field)field).getName() : result.value();
                            Field idF = ReflectProperty.getProperty(mainClass, fieldName);
                            Field idF_A = ReflectProperty.getProperty(addClass, fieldName);
                            if (null == idF && null == idF_A) continue;
                            String data = "";
                            if (null != idF) {
                                idF.setAccessible(true);
                                data = StringHelp.safeToString(idF.get(left));
                            } else if (null != idF_A) {
                                idF_A.setAccessible(true);
                                data = StringHelp.safeToString(idF_A.get(right));
                            }
                            ModelCopier.fieldSet(obj, (Field)field, data, true);
                        }
                        catch (Exception ex) {
                            ((Field)field).set(obj, null);
                        }
                    }
                    resData = obj;
                    return resData;
                }
                catch (Exception ex) {
                    return null;
                }
            })).collect(Collectors.toList());
            resList = ListHelp.removeNull(resList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resList;
    }

    public static <M, A, R> List<R> leftJoin(List<M> mainList, List<A> addList, String joinName, Class<R> resClass) {
        List<Object> resList = new ArrayList();
        if (!ListHelp.safeAny(mainList)) {
            return resList;
        }
        if (!ListHelp.safeAny(addList)) {
            resList = ModelCopier.CopyList(mainList, resClass);
            return resList;
        }
        try {
            Class<?> mainClass = mainList.get(0).getClass();
            Class<?> addClass = addList.get(0).getClass();
            Field field_M = ReflectProperty.getProperty(mainClass, joinName);
            Field field_A = ReflectProperty.getProperty(addClass, joinName);
            if (null == field_M || null == field_A) {
                resList = ModelCopier.CopyList(mainList, resClass);
                return resList;
            }
            field_M.setAccessible(true);
            field_A.setAccessible(true);
            resList = mainList.stream().map(left -> {
                if (!addList.stream().anyMatch(e -> {
                    try {
                        return field_A.get(e).equals(field_M.get(left));
                    }
                    catch (Exception ex) {
                        return false;
                    }
                })) {
                    try {
                        Object resData = ListConvertHelp.mergeEntity(left, addClass.newInstance(), resClass);
                        return resData;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                return addList.stream().filter(right -> {
                    try {
                        return field_M.get(left).equals(field_A.get(right));
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }).filter(ListConvertHelp.distinctByKey(right -> field_A)).map(right -> {
                    try {
                        Object resData = ListConvertHelp.mergeEntity(left, right, resClass);
                        return resData;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }).findFirst().orElse(null);
            }).collect(Collectors.toList());
            resList = ListHelp.removeNull(resList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resList;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <M, A, R> R mergeEntity(M left, A right, Class<R> resClass) throws Exception {
        R resData = null;
        Class<?> mainClass = left.getClass();
        Class<?> addClass = right.getClass();
        AccessibleObject[] declaredFields = resClass.getDeclaredFields();
        AccessibleObject.setAccessible(declaredFields, true);
        R obj = resClass.newInstance();
        for (AccessibleObject field : declaredFields) {
            try {
                ModelMapped result = AnnotationHelp.getFieldAnnotation(resClass, ((Field)field).getName(), ModelMapped.class);
                String fieldName = null == result ? ((Field)field).getName() : result.value();
                Field idF = ReflectProperty.getProperty(mainClass, fieldName);
                Field idF_A = ReflectProperty.getProperty(addClass, fieldName);
                if (null == idF && null == idF_A) continue;
                String data = "";
                if (null != idF) {
                    idF.setAccessible(true);
                    data = StringHelp.safeToString(idF.get(left));
                } else if (null != idF_A && null != right) {
                    idF_A.setAccessible(true);
                    data = StringHelp.safeToString(idF_A.get(right));
                }
                ModelCopier.fieldSet(obj, (Field)field, data, true);
            }
            catch (Exception ex) {
                ((Field)field).set(obj, null);
            }
        }
        resData = obj;
        return resData;
    }

    public static <T> List<T> getListPage(List<T> collect, int page, int row) {
        int fromIndex = 0;
        int toIndex = 0;
        List<T> detailPojos = null;
        if (!ListHelp.safeAny(collect) || page == 0 && row == 0) {
            return collect;
        }
        int total = collect.size();
        double ceil = Math.ceil((double)total / (double)row);
        int totalPage = Double.valueOf(ceil).intValue();
        if (page <= totalPage && page > 0) {
            fromIndex = (page - 1) * row;
            toIndex = page == totalPage ? total : page * row;
        }
        detailPojos = total <= toIndex ? collect.subList(fromIndex, total) : collect.subList(fromIndex, toIndex);
        return detailPojos;
    }
}

