/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.landedestate.basecommon.logger;

import com.xforceplus.landedestate.basecommon.help.lang.StringHelp;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public final class LogTagHelp {
    public static <T> HashMap<String, String> getlogTag(HttpServletRequest httprequest, T t) {
        HashMap<String, String> logtag = new HashMap<String, String>();
        if (httprequest.getAttribute("rid") == null) {
            httprequest.setAttribute("rid", (Object)UUID.randomUUID());
        }
        logtag.put("rid", httprequest.getAttribute("rid").toString());
        if (t != null) {
            logtag.put("s", t.getClass().getName());
        }
        if (httprequest.getAttribute("ip ") != null) {
            logtag.put("ip ", httprequest.getAttribute("ip ").toString());
        }
        return logtag;
    }

    public static <T> HashMap<String, String> getSoaLogTag(T t) {
        HashMap<String, String> logtag = new HashMap<String, String>();
        try {
            Class<?> doClass = t.getClass();
            AccessibleObject[] declaredFields = doClass.getDeclaredFields();
            AccessibleObject.setAccessible(declaredFields, true);
            for (AccessibleObject field : declaredFields) {
                if (StringHelp.safeIsEmpty(((Field)field).get(t))) continue;
                if (StringHelp.ignoreCaseEquals("uid", ((Field)field).getName())) {
                    logtag.put("uid", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("rid", ((Field)field).getName()) || StringHelp.ignoreCaseEquals("requestId", ((Field)field).getName())) {
                    logtag.put("rid", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("corpid", ((Field)field).getName())) {
                    logtag.put("cid", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("eid", ((Field)field).getName())) {
                    logtag.put("eid", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("orderid", ((Field)field).getName())) {
                    logtag.put("oid", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("mobile", ((Field)field).getName()) || StringHelp.ignoreCaseEquals("mobilephone", ((Field)field).getName())) {
                    logtag.put("mobile", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (StringHelp.ignoreCaseEquals("email", ((Field)field).getName())) {
                    logtag.put("email", StringHelp.safeToString(((Field)field).get(t)));
                    continue;
                }
                if (!StringHelp.ignoreCaseEquals("username", ((Field)field).getName()) && !StringHelp.ignoreCaseEquals("name", ((Field)field).getName())) continue;
                logtag.put("name", StringHelp.safeToString(((Field)field).get(t)));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return logtag;
    }

    public final class LogTitle {
        public static final String RESQUEST_RID = "rid";
        public static final String RESQUEST_LOGID = "id";
        public static final String RESQUEST_DOC = "req";
        public static final String RESPONSE_DOC = "res";
        public static final String RESQUEST_UID = "uid";
        public static final String RESQUEST_CORPID = "cid";
        public static final String RESQUEST_ORDERID = "oid";
        public static final String RESQUEST_MOBILE = "mobile";
        public static final String RESQUEST_EMAIL = "email";
        public static final String RESQUEST_USERNAME = "name";
        public static final String RESQUEST_EID = "eid";
        public static final String PROCESSTIME = "time";
        public static final String SERVICE_NAME = "s";
        public static final String ACTION_NAME = "a";
        public static final String RESQUEST_IP = "ip ";
    }
}

