package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.request.BatchRequest;
import com.xforceplus.vanke.in.client.model.BatchUpdateExceptionRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetExceptionListRequest;
import com.xforceplus.vanke.in.client.model.UpdateExceptionRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "exception", description = "the exception API")
public interface ExceptionApi {

    @ApiOperation(value = "批量删除异常工单表信息", notes = "批量删除异常工单表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/exception",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse batchDeleteException(@ApiParam(value = "request" ,required=true ) @RequestBody BatchRequest request);


    @ApiOperation(value = "批量挂起异常数据", notes = "批量挂起异常数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/exception",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse batchHangUpException(@ApiParam(value = "request" ,required=true ) @RequestBody BatchUpdateExceptionRequest request);


    @ApiOperation(value = "导出异常工单表列表", notes = "导出异常工单表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/exception/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse exportException(@ApiParam(value = "request" ,required=true ) @RequestBody GetExceptionListRequest request);


    @ApiOperation(value = "获取异常工单表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/exception/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getExceptionDetail(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取异常工单表列表", notes = "获取异常工单表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/exception",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getExceptionList(@ApiParam(value = "request" ,required=true ) @RequestBody GetExceptionListRequest request);


    @ApiOperation(value = "获取异常工单表列表统计", notes = "获取异常工单表数据统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/exception/stat",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getExceptionStat(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "更新异常工单表信息", notes = "更新异常工单表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "exception", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "更新结果" ) })
    @RequestMapping(value = "/exception/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse updateException(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody UpdateExceptionRequest request);

}
