package com.xforceplus.vanke.in.client.api;

import com.xforceplus.vanke.in.client.model.AuthSummaryRequest;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import java.io.File;
import com.xforceplus.vanke.in.client.model.GetImageUrlForGxRequest;
import com.xforceplus.vanke.in.client.model.InvoiceAuthRequest;
import com.xforceplus.vanke.in.client.model.SendAuthRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceAuth", description = "the invoiceAuth API")
public interface InvoiceAuthApi {

    @ApiOperation(value = "认证导出", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/authExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse authExport(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuthRequest request);


    @ApiOperation(value = "认证导入", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回" ) })
    @RequestMapping(value = "/invoiceAuth/authImport",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.POST)
     CommonResponse authImport( @NotNull @ApiParam(value = "", required = true) @RequestParam(value = "rid", required = true) String rid,@ApiParam(value = "file detail") @RequestPart("file") MultipartFile file);


    @ApiOperation(value = "认证汇总列表页", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/authSummary",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse authSummary(@ApiParam(value = "request" ,required=true ) @RequestBody AuthSummaryRequest request);


    @ApiOperation(value = "获取认证统计发票明细列表", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/authSummaryDetail",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse authSummaryDetail(@ApiParam(value = "request" ,required=true ) @RequestBody AuthSummaryRequest request);


    @ApiOperation(value = "发票认证金额统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAuth/countAuthAmount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse countAuthAmount(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuthRequest request);


    @ApiOperation(value = "获取认证发票列表", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/getAuthInvoiceInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse getAuthInvoiceInfo(@ApiParam(value = "request" ,required=true ) @RequestBody SendAuthRequest request);


    @ApiOperation(value = "获取认证发票统计数据", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/getAuthInvoiceInfoStatistic",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getAuthInvoiceInfoStatistic(@ApiParam(value = "request" ,required=true ) @RequestBody SendAuthRequest request);


    @ApiOperation(value = "获取勾选列表统计", notes = "获取勾选列表统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoiceAuth/getAuthNumStat",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getAuthNumStat(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取查看国信影像地址", notes = "获取查看国信影像地址" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoiceAuth/getImageUrlForGx",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getImageUrlForGx(@ApiParam(value = "request" ,required=true ) @RequestBody GetImageUrlForGxRequest request);


    @ApiOperation(value = "发票认证列表", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAuth/getInvoiceAuthList",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceAuthList(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuthRequest request);


    @ApiOperation(value = "发送认证", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/sendAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse sendAuth(@ApiParam(value = "request" ,required=true ) @RequestBody SendAuthRequest request);


    @ApiOperation(value = "发送认证导出", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAuth", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceAuth/sendAuthExport",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse sendAuthExport(@ApiParam(value = "request" ,required=true ) @RequestBody SendAuthRequest request);

}
