package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetOrdersEndcheckListRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "ordersEndcheck", description = "the ordersEndcheck API")
public interface OrdersEndcheckApi {

    @ApiOperation(value = "导出月末核对列表", notes = "导出月末核对数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "ordersEndcheck", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ordersEndcheck/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse exportOrdersEndcheck(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersEndcheckListRequest request);


    @ApiOperation(value = "获取月末核对列表", notes = "获取月末核对数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "ordersEndcheck", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ordersEndcheck",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrdersEndcheckList(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersEndcheckListRequest request);

}
