package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.BatchDeleteRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetOrdersListRequest;
import com.xforceplus.vanke.in.client.model.GetPostcodeListRequest;
import com.xforceplus.vanke.in.client.model.GetPostcodeOrdersListRequest;
import com.xforceplus.vanke.in.client.model.SavePostcodeRequest;
import com.xforceplus.vanke.in.client.model.SignOrdersRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "postcode", description = "the postcode API")
public interface PostcodeApi {

    @ApiOperation(value = "批量删除邮包", notes = "批量删除邮包" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/postcode/batchDelete",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse batchDelete(@ApiParam(value = "request" ,required=true ) @RequestBody BatchDeleteRequest request);


    @ApiOperation(value = "业务单删除", notes = "业务单删除" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/postcode/deleteOrder",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse deleteOrder(@ApiParam(value = "request" ,required=true ) @RequestBody BatchDeleteRequest request);


    @ApiOperation(value = "导出签收管理表列表", notes = "导出签收管理表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/postcode/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse exportPostcode(@ApiParam(value = "request" ,required=true ) @RequestBody GetPostcodeListRequest request);


    @ApiOperation(value = "获取邮包业务单", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询结果" ) })
    @RequestMapping(value = "/postcode/orders",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrdersList(@ApiParam(value = "" ,required=true ) @RequestBody GetPostcodeOrdersListRequest request);


    @ApiOperation(value = "获取签收管理表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/postcode/{packageCode}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPostcodeDetail(@ApiParam(value = "运单号",required=true ) @PathVariable("packageCode") String packageCode,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取签收管理表列表", notes = "获取签收管理表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/postcode",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPostcodeList(@ApiParam(value = "request" ,required=true ) @RequestBody GetPostcodeListRequest request);


    @ApiOperation(value = "新增签收管理表", notes = "新增签收管理表" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/postcode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse savePostcode(@ApiParam(value = "request" ,required=true ) @RequestBody SavePostcodeRequest request);


    @ApiOperation(value = "导出签收列表", notes = "导出签收数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/postcode/sign/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse signExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersListRequest request);


    @ApiOperation(value = "业务单签收", notes = "业务单签收" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "postcode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/postcode/signOrders",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse signOrders(@ApiParam(value = "request" ,required=true ) @RequestBody SignOrdersRequest request);

}
