package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetUserPerfRequest;
import com.xforceplus.vanke.in.client.model.GetWorkDifferenceRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "report", description = "the report API")
public interface ReportApi {

    @ApiOperation(value = "日报统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "report", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/report/getDaily",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getDaily(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "异常统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "report", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/report/getException",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getException(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "员工绩效", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "report", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/report/getUserPerf",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getUserPerf(@ApiParam(value = "request" ,required=true ) @RequestBody GetUserPerfRequest request);


    @ApiOperation(value = "工作差异统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "report", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/report/getWorkDifference",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getWorkDifference(@ApiParam(value = "request" ,required=true ) @RequestBody GetWorkDifferenceRequest request);

}
