package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetSmInvoiceListRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "smInvoice", description = "the smInvoice API")
public interface SmInvoiceApi {

    @ApiOperation(value = "导出扫描发票", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/smInvoice/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse exportSmInvoice(@ApiParam(value = "request" ,required=true ) @RequestBody GetSmInvoiceListRequest request);


    @ApiOperation(value = "获取扫描发票表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/smInvoice/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmInvoiceDetail(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取扫描发票表列表", notes = "获取扫描发票表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/smInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmInvoiceList(@ApiParam(value = "request" ,required=true ) @RequestBody GetSmInvoiceListRequest request);

}
