package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量删除邮包Request
 */
@ApiModel(description = "批量删除邮包Request")

@JsonInclude(NON_NULL)
public class BatchDeleteRequest extends BaseRequest {
  @JsonProperty("ids")
  private List<Long> ids = new ArrayList<Long>();

  @JsonIgnore
  public BatchDeleteRequest ids(List<Long> ids) {
    this.ids = ids;
    return this;
  }

  public BatchDeleteRequest addIdsItem(Long idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * 主键
   * @return ids
  **/
  @ApiModelProperty(value = "主键")
  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchDeleteRequest batchDeleteRequest = (BatchDeleteRequest) o;
    return Objects.equals(this.ids, batchDeleteRequest.ids) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ids, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchDeleteRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
