package com.xforceplus.vanke.in.client.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 业务发票表
 */
public class EnInvoiceRequestBean implements Serializable {

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 业务单号
   */
  private String orderCode;

  /**
   * 原发票代码
   */
  private String originInvoiceCode;

  /**
   * 原发票号码
   */
  private String originInvoiceNo;

  /**
   * 系统来源
   */
  private List<String> systemOrigList;
  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 开票日期（yyyyMMdd）
   */
  private String paperDrewDate;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 发票状态
   */
  private String status;

  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  public List<String> getSystemOrigList() {
    return systemOrigList;
  }

  public void setSystemOrigList(List<String> systemOrigList) {
    this.systemOrigList = systemOrigList;
  }

  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }
}
