package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 异常工单表Request
 */
@ApiModel(description = "异常工单表Request")

@JsonInclude(NON_NULL)
public class GetExceptionListRequest extends PageRequest {
  @JsonProperty("handleStatus")
  private Integer handleStatus = null;

  @JsonProperty("exceptionType")
  private List<Integer> exceptionType = new ArrayList<Integer>();

  @JsonProperty("errorType")
  private List<String> errorType = new ArrayList<String>();

  @JsonProperty("orderCode")
  private List<String> orderCode = new ArrayList<String>();

  @JsonProperty("productTime")
  private List<Long> productTime = new ArrayList<Long>();

  @JsonProperty("producter")
  private List<String> producter = new ArrayList<String>();

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("hasInvoice")
  private Boolean hasInvoice = null;

  @JsonProperty("documentType")
  private Integer documentType = null;

  @JsonProperty("exceptionIds")
  private List<Long> exceptionIds = new ArrayList<Long>();

  @JsonIgnore
  public GetExceptionListRequest handleStatus(Integer handleStatus) {
    this.handleStatus = handleStatus;
    return this;
  }

   /**
   * 处理状态
   * @return handleStatus
  **/
  @ApiModelProperty(value = "处理状态")
  public Integer getHandleStatus() {
    return handleStatus;
  }

  public void setHandleStatus(Integer handleStatus) {
    this.handleStatus = handleStatus;
  }

  @JsonIgnore
  public GetExceptionListRequest exceptionType(List<Integer> exceptionType) {
    this.exceptionType = exceptionType;
    return this;
  }

  public GetExceptionListRequest addExceptionTypeItem(Integer exceptionTypeItem) {
    this.exceptionType.add(exceptionTypeItem);
    return this;
  }

   /**
   * 异常类型
   * @return exceptionType
  **/
  @ApiModelProperty(value = "异常类型")
  public List<Integer> getExceptionType() {
    return exceptionType;
  }

  public void setExceptionType(List<Integer> exceptionType) {
    this.exceptionType = exceptionType;
  }

  @JsonIgnore
  public GetExceptionListRequest errorType(List<String> errorType) {
    this.errorType = errorType;
    return this;
  }

  public GetExceptionListRequest addErrorTypeItem(String errorTypeItem) {
    this.errorType.add(errorTypeItem);
    return this;
  }

   /**
   * 异常原因分类
   * @return errorType
  **/
  @ApiModelProperty(value = "异常原因分类")
  public List<String> getErrorType() {
    return errorType;
  }

  public void setErrorType(List<String> errorType) {
    this.errorType = errorType;
  }

  @JsonIgnore
  public GetExceptionListRequest orderCode(List<String> orderCode) {
    this.orderCode = orderCode;
    return this;
  }

  public GetExceptionListRequest addOrderCodeItem(String orderCodeItem) {
    this.orderCode.add(orderCodeItem);
    return this;
  }

   /**
   * 异常单号
   * @return orderCode
  **/
  @ApiModelProperty(value = "异常单号")
  public List<String> getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(List<String> orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public GetExceptionListRequest productTime(List<Long> productTime) {
    this.productTime = productTime;
    return this;
  }

  public GetExceptionListRequest addProductTimeItem(Long productTimeItem) {
    this.productTime.add(productTimeItem);
    return this;
  }

   /**
   * 异常时间
   * @return productTime
  **/
  @ApiModelProperty(value = "异常时间")
  public List<Long> getProductTime() {
    return productTime;
  }

  public void setProductTime(List<Long> productTime) {
    this.productTime = productTime;
  }

  @JsonIgnore
  public GetExceptionListRequest producter(List<String> producter) {
    this.producter = producter;
    return this;
  }

  public GetExceptionListRequest addProducterItem(String producterItem) {
    this.producter.add(producterItem);
    return this;
  }

   /**
   * 提交人(发起人)
   * @return producter
  **/
  @ApiModelProperty(value = "提交人(发起人)")
  public List<String> getProducter() {
    return producter;
  }

  public void setProducter(List<String> producter) {
    this.producter = producter;
  }

  @JsonIgnore
  public GetExceptionListRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public GetExceptionListRequest hasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
    return this;
  }

   /**
   * 是否包含发票
   * @return hasInvoice
  **/
  @ApiModelProperty(value = "是否包含发票")
  public Boolean getHasInvoice() {
    return hasInvoice;
  }

  public void setHasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
  }

  @JsonIgnore
  public GetExceptionListRequest documentType(Integer documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * 文档类型： 1-业务单，2-发票，9-其他
   * @return documentType
  **/
  @ApiModelProperty(value = "文档类型： 1-业务单，2-发票，9-其他")
  public Integer getDocumentType() {
    return documentType;
  }

  public void setDocumentType(Integer documentType) {
    this.documentType = documentType;
  }

  @JsonIgnore
  public GetExceptionListRequest exceptionIds(List<Long> exceptionIds) {
    this.exceptionIds = exceptionIds;
    return this;
  }

  public GetExceptionListRequest addExceptionIdsItem(Long exceptionIdsItem) {
    this.exceptionIds.add(exceptionIdsItem);
    return this;
  }

   /**
   * 异常id
   * @return exceptionIds
  **/
  @ApiModelProperty(value = "异常id")
  public List<Long> getExceptionIds() {
    return exceptionIds;
  }

  public void setExceptionIds(List<Long> exceptionIds) {
    this.exceptionIds = exceptionIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetExceptionListRequest getExceptionListRequest = (GetExceptionListRequest) o;
    return Objects.equals(this.handleStatus, getExceptionListRequest.handleStatus) &&
        Objects.equals(this.exceptionType, getExceptionListRequest.exceptionType) &&
        Objects.equals(this.errorType, getExceptionListRequest.errorType) &&
        Objects.equals(this.orderCode, getExceptionListRequest.orderCode) &&
        Objects.equals(this.productTime, getExceptionListRequest.productTime) &&
        Objects.equals(this.producter, getExceptionListRequest.producter) &&
        Objects.equals(this.packageCode, getExceptionListRequest.packageCode) &&
        Objects.equals(this.hasInvoice, getExceptionListRequest.hasInvoice) &&
        Objects.equals(this.documentType, getExceptionListRequest.documentType) &&
        Objects.equals(this.exceptionIds, getExceptionListRequest.exceptionIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(handleStatus, exceptionType, errorType, orderCode, productTime, producter, packageCode, hasInvoice, documentType, exceptionIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetExceptionListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    handleStatus: ").append(toIndentedString(handleStatus)).append("\n");
    sb.append("    exceptionType: ").append(toIndentedString(exceptionType)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    productTime: ").append(toIndentedString(productTime)).append("\n");
    sb.append("    producter: ").append(toIndentedString(producter)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    hasInvoice: ").append(toIndentedString(hasInvoice)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    exceptionIds: ").append(toIndentedString(exceptionIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
